/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean checkState;

    public YieldNode(ISourcePosition position, Node argsNode, boolean checkState) {
        super(position, NodeType.YIELDNODE);
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.checkState = checkState;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public boolean getCheckState() {
        return this.checkState;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = null;
        if (this.argsNode != null) {
            result = this.argsNode.interpret(runtime, context, self, aBlock);
        }
        return context.getCurrentFrame().getBlock().yield(context, result, null, null, this.checkState);
    }
}

