/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.MetaClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected RubyModule protectedClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        assert (implementationClass != null);
        this.visibility = visibility;
        this.implementationClass = implementationClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implementationClass);
        this.callConfig = callConfig;
    }

    protected DynamicMethod() {
        assert (this instanceof UndefinedMethod);
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
        return this.call(context, self, clazz, name, args, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject arg) {
        return this.call(context, self, klazz, name, arg, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self, klazz, name, arg1, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.call(context, self, klazz, name, arg1, arg2, arg3, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name) {
        return this.call(context, self, klazz, name, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, Block block) {
        return this.call(context, self, klazz, name, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject arg, Block block) {
        return this.call(context, self, klazz, name, new IRubyObject[]{arg}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self, klazz, name, new IRubyObject[]{arg1, arg2}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.call(context, self, klazz, name, new IRubyObject[]{arg1, arg2, arg3}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                return this.protectedAccessOk(caller);
            }
        }
        return true;
    }

    private boolean protectedAccessOk(IRubyObject caller) {
        return this.getProtectedClass().isInstance(caller);
    }

    protected static RubyModule calculateProtectedClass(RubyModule cls) {
        if (cls.isSingleton()) {
            cls = cls.getSuperClass();
        }
        while (cls.isIncluded()) {
            cls = cls.getMetaClass();
        }
        if (cls instanceof MetaClass) {
            cls = ((MetaClass)cls).getRealClass();
        }
        return cls;
    }

    protected RubyModule getProtectedClass() {
        return this.protectedClass;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implClass);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public final boolean isUndefined() {
        return this instanceof UndefinedMethod;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfig) {
        this.callConfig = callConfig;
    }

    public boolean isNative() {
        return false;
    }
}

