/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Binding {
    private IRubyObject self;
    private final Frame frame;
    private Visibility visibility;
    private RubyModule klass;
    private final DynamicScope dynamicScope;

    public Binding(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        this.self = self;
        this.frame = frame.duplicate();
        this.visibility = visibility;
        this.klass = klass;
        this.dynamicScope = dynamicScope;
    }

    public Binding(Frame frame, RubyModule bindingClass, DynamicScope dynamicScope) {
        this.self = frame.getSelf();
        this.frame = frame.duplicate();
        this.visibility = frame.getVisibility();
        this.klass = bindingClass;
        this.dynamicScope = dynamicScope;
    }

    public Binding cloneBinding() {
        Binding newBlock = new Binding(this.self, this.frame.duplicate(), this.visibility, this.klass, this.dynamicScope.cloneScope());
        return newBlock;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public DynamicScope getDynamicScope() {
        return this.dynamicScope;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public RubyModule getKlass() {
        return this.klass;
    }

    public boolean isGiven() {
        return true;
    }
}

