/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class CallSite {
    public final String methodName;
    protected final CallType callType;

    public CallSite(String methodName, CallType callType) {
        this.methodName = methodName;
        this.callType = callType;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public static class GeCallSite
    extends InlineCachingCallSite {
        public GeCallSite() {
            super(">=", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_ge(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class GtCallSite
    extends InlineCachingCallSite {
        public GtCallSite() {
            super(">", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_gt(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class LeCallSite
    extends InlineCachingCallSite {
        public LeCallSite() {
            super("<=", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_le(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class LtCallSite
    extends InlineCachingCallSite {
        public LtCallSite() {
            super("<", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_lt(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class DivCallSite
    extends InlineCachingCallSite {
        public DivCallSite() {
            super("/", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_div(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class MulCallSite
    extends InlineCachingCallSite {
        public MulCallSite() {
            super("*", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_mul(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class MinusCallSite
    extends InlineCachingCallSite {
        public MinusCallSite() {
            super("-", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_minus(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class PlusCallSite
    extends InlineCachingCallSite {
        public PlusCallSite() {
            super("+", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg) {
            if (self instanceof RubyFixnum) {
                return ((RubyFixnum)self).op_plus(context, arg);
            }
            return super.call(context, self, arg);
        }
    }

    public static class InlineCachingCallSite
    extends CallSite
    implements CacheMap.CacheSite {
        private static final CacheEntry NULL_CACHE = new CacheEntry(null, null);
        private volatile CacheEntry cache = NULL_CACHE;
        private int misses = 0;
        private static final int MAX_MISSES = 50;

        public InlineCachingCallSite(String methodName, CallType callType) {
            super(methodName, callType);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, IRubyObject[] args, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, args, block);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, args, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, IRubyObject[] args, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMising(context, self, method, args);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, args);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, selfType, this.methodName);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, block);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, arg);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, arg, block);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, arg1, arg2);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, arg1, arg2, block);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, arg1, arg2, arg3);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (this.methodMissing(method, context)) {
                return this.callMethodMissing(context, self, method, arg1, arg2, arg3, block);
            }
            this.updateCacheEntry(method, selfType);
            return method.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
        }

        private IRubyObject callMethodMising(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject[] args) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, args, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, IRubyObject.NULL_ARRAY, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, IRubyObject.NULL_ARRAY, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject arg) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg}, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject[] args, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, args, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject arg, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg}, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject arg1, IRubyObject arg2) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2}, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject arg1, IRubyObject arg2, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2}, context.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2, arg3}, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext context, IRubyObject self, DynamicMethod method, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2, arg3}, context.getFrameSelf(), this.callType, block);
        }

        private boolean methodMissing(DynamicMethod method, ThreadContext context) {
            return method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType);
        }

        private RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
            context.callThreadPoll();
            RubyClass selfType = self.getMetaClass();
            return selfType;
        }

        private void updateCacheEntry(DynamicMethod method, RubyClass selfType) {
            if (this.misses < 50) {
                ++this.misses;
                this.cache = new CacheEntry(method, selfType);
                selfType.getRuntime().getCacheMap().add(method, this);
            }
        }

        public void removeCachedMethod() {
            this.cache = NULL_CACHE;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.cachedType == selfType) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args);
            }
            return this.cacheAndCall(selfType, args, context, self);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.cachedType == selfType) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args, block);
                }
                return this.cacheAndCall(selfType, block, args, context, self);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.cachedType == selfType) {
                return myCache.cachedMethod.call(context, self, selfType, this.methodName);
            }
            return this.cacheAndCall(selfType, context, self);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.cachedType == selfType) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, block);
                }
                return this.cacheAndCall(selfType, block, context, self);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.cachedType == selfType) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1);
            }
            return this.cacheAndCall(selfType, context, self, arg1);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.cachedType == selfType) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.cachedType == selfType) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
            }
            return this.cacheAndCall(selfType, context, self, arg1, arg2);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.cachedType == selfType) {
                    return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1, arg2);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            CacheEntry myCache = this.cache;
            if (myCache.cachedType == selfType) {
                return myCache.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
            }
            return this.cacheAndCall(selfType, context, self, arg1, arg2, arg3);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            RubyClass selfType = this.pollAndGetClass(context, self);
            try {
                CacheEntry myCache = this.cache;
                if (myCache.cachedType == selfType) {
                    return myCache.cachedMethod.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1, arg2, arg3);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        private IRubyObject handleBreakJump(JumpException.BreakJump bj, Block block) throws JumpException.BreakJump {
            if (block.getBody() == bj.getTarget()) {
                return (IRubyObject)bj.getValue();
            }
            throw bj;
        }

        private static class CacheEntry {
            public final DynamicMethod cachedMethod;
            public final RubyClass cachedType;

            public CacheEntry(DynamicMethod method, RubyClass type) {
                this.cachedMethod = method;
                this.cachedType = type;
            }
        }
    }
}

