/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyClass;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class Dispatcher {
    public static final Dispatcher DEFAULT_DISPATCHER = new DefaultDispatcher();
    protected byte[] switchTable;

    public abstract IRubyObject callMethod(ThreadContext var1, IRubyObject var2, RubyClass var3, int var4, String var5, IRubyObject[] var6, CallType var7, Block var8);

    public void clearIndex(int index) {
        if (index >= this.switchTable.length) {
            return;
        }
        this.switchTable[index] = 0;
    }

    private static class DefaultDispatcher
    extends Dispatcher {
        public DefaultDispatcher() {
            this.switchTable = new byte[0];
        }

        public IRubyObject callMethod(ThreadContext context, IRubyObject self, RubyClass rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
            try {
                return RuntimeHelpers.invokeAs(context, rubyclass, self, name, args, callType, block);
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }
    }
}

