/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public final class IdUtil {
    public static boolean isConstant(String id) {
        return Character.isUpperCase(id.charAt(0));
    }

    public static boolean isClassVariable(String id) {
        return id.length() > 1 && id.charAt(0) == '@' && id.charAt(1) == '@';
    }

    public static boolean isInstanceVariable(String id) {
        return id.length() > 0 && id.charAt(0) == '@' && (id.length() < 2 || id.charAt(1) != '@');
    }

    public static boolean isGlobal(String id) {
        return id.length() > 0 && id.charAt(0) == '$';
    }

    public static boolean isLocal(String id) {
        return !IdUtil.isGlobal(id) && !IdUtil.isClassVariable(id) && !IdUtil.isInstanceVariable(id) && !IdUtil.isConstant(id);
    }

    public static boolean isAttrSet(String id) {
        return id.endsWith("=");
    }

    public static boolean isValidConstantName(String id) {
        char c;
        int len = id.length();
        if (len > 0 && (c = id.charAt(0)) <= 'Z' && c >= 'A') {
            return IdUtil.isNameString(id, 1, len);
        }
        return false;
    }

    public static boolean isValidInstanceVariableName(String id) {
        int len = id.length();
        if (len > 0 && '@' == id.charAt(0)) {
            if (len > 1) {
                if (IdUtil.isInitialCharacter(id.charAt(1))) {
                    return IdUtil.isNameString(id, 2, len);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidClassVariableName(String id) {
        int len = id.length();
        if (len > 1 && '@' == id.charAt(0) && '@' == id.charAt(1)) {
            if (len > 2) {
                if (IdUtil.isInitialCharacter(id.charAt(2))) {
                    return IdUtil.isNameString(id, 3, len);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isInitialCharacter(int c) {
        return (c &= 0xFFFFFFDF) <= 90 && c >= 65 || c == 95;
    }

    public static boolean isNameCharacter(char c) {
        int letter = c & 0xFFFFFFDF;
        return letter <= 90 && letter >= 65 || c == '_' || c <= '9' && c >= '0';
    }

    public static boolean isNameString(String id, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            if (IdUtil.isNameCharacter(id.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

