/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.endpoints.DefaultHttpConsumerMarshaler;
import org.apache.servicemix.http.endpoints.HttpConsumerMarshaler;
import org.apache.servicemix.http.exception.HttpTimeoutException;
import org.apache.servicemix.http.exception.LateResponseException;
import org.apache.servicemix.http.jetty.ContinuationHelper;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.w3c.dom.Node;

public class HttpConsumerEndpoint
extends ConsumerEndpoint
implements HttpProcessor,
HttpEndpointType {
    public static final String MAIN_WSDL = "main.wsdl";
    private String authMethod;
    private SslParameters ssl;
    private String locationURI;
    private HttpConsumerMarshaler marshaler;
    private long timeout;
    private URI defaultMep = JbiConstants.IN_OUT;
    private Map<String, Object> resources = new HashMap<String, Object>();
    private Map<String, Continuation> continuations = new ConcurrentHashMap<String, Continuation>();
    private Map<String, Object> mutexes = new ConcurrentHashMap<String, Object>();
    private Object httpContext;
    private boolean started = false;
    private LateResponseStrategy lateResponseStrategy = LateResponseStrategy.error;

    public HttpConsumerEndpoint() {
    }

    public HttpConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HttpConsumerMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpConsumerMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public SslParameters getSsl() {
        return this.ssl;
    }

    public void setSsl(SslParameters ssl) {
        this.ssl = ssl;
    }

    public URI getDefaultMep() {
        return this.defaultMep;
    }

    public void setDefaultMep(URI defaultMep) {
        this.defaultMep = defaultMep;
    }

    public String getLateResponseStrategy() {
        return this.lateResponseStrategy.name();
    }

    public void setLateResponseStrategy(String value) {
        this.lateResponseStrategy = LateResponseStrategy.valueOf(value);
    }

    public void activate() throws Exception {
        super.activate();
        this.loadStaticResources();
        this.httpContext = this.getServerManager().createContext(this.locationURI, this);
    }

    public void deactivate() throws Exception {
        this.getServerManager().remove(this.httpContext);
        this.httpContext = null;
        super.deactivate();
    }

    public void start() throws Exception {
        super.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        String id = exchange.getExchangeId();
        Object mutex = this.mutexes.get(id);
        if (mutex == null) {
            this.handleLateResponse(exchange);
            return;
        }
        Object object = mutex;
        synchronized (object) {
            Continuation continuation = this.continuations.get(id);
            if (continuation != null && continuation.isPending()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Resuming continuation for exchange: " + id));
                }
                continuation.setObject((Object)exchange);
                continuation.resume();
                if (!continuation.isResumed()) {
                    this.handleLateResponse(exchange);
                }
            } else {
                this.handleLateResponse(exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageExchange exchange = null;
        try {
            Object mutex;
            if (this.handleStaticResource(request, response)) {
                return;
            }
            long to = this.timeout;
            if (to == 0L) {
                to = ((HttpComponent)this.getServiceUnit().getComponent()).getConfiguration().getConsumerProcessorSuspendTime();
            }
            Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, null);
            exchange = (MessageExchange)continuation.getObject();
            Object object = mutex = this.getOrCreateMutex(exchange);
            synchronized (object) {
                if (ContinuationHelper.isNewContinuation(continuation)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Receiving HTTP request: " + request));
                    }
                    if (!this.started) {
                        response.sendError(503, "Endpoint is stopped");
                        return;
                    }
                    exchange = this.createExchange(request);
                    String id = exchange.getExchangeId();
                    continuation.setObject((Object)exchange);
                    this.mutexes.put(id, mutex);
                    this.continuations.put(id, continuation);
                    this.send(exchange);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Suspending continuation for exchange: " + id));
                    }
                } else {
                    this.logger.debug((Object)("Resuming HTTP request: " + request));
                }
                boolean istimeout = !continuation.suspend(to);
                exchange = this.doEndContinuation(continuation);
                if (istimeout) {
                    throw new HttpTimeoutException(exchange);
                }
            }
            this.handleResponse(exchange, request, response);
        }
        catch (RetryRequest e) {
            throw e;
        }
        catch (Exception e) {
            this.sendError(exchange, e, request, response);
        }
    }

    private void handleResponse(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Exception e = exchange.getError();
            if (e == null) {
                e = new Exception("Unknown error (exchange aborted ?)");
            }
            throw e;
        }
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            try {
                Fault fault = exchange.getFault();
                if (fault != null) {
                    this.sendFault(exchange, fault, request, response);
                } else {
                    NormalizedMessage outMsg = exchange.getMessage("out");
                    if (outMsg != null) {
                        this.sendOut(exchange, outMsg, request, response);
                    }
                }
                this.done(exchange);
            }
            catch (Exception e) {
                this.fail(exchange, e);
                throw e;
            }
        } else if (exchange.getStatus() == ExchangeStatus.DONE) {
            this.sendAccepted(exchange, request, response);
        }
    }

    private void handleLateResponse(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            if (this.lateResponseStrategy == LateResponseStrategy.error) {
                this.fail(exchange, new LateResponseException(exchange));
            } else {
                this.logger.warn((Object)LateResponseException.createMessage(exchange));
                this.done(exchange);
            }
        }
    }

    private Object getOrCreateMutex(MessageExchange exchange) {
        Object result = null;
        if (exchange != null) {
            result = this.mutexes.get(exchange.getExchangeId());
        }
        if (result == null) {
            result = new Object();
        }
        return result;
    }

    private MessageExchange doEndContinuation(Continuation continuation) {
        MessageExchange exchange = (MessageExchange)continuation.getObject();
        String id = exchange.getExchangeId();
        continuation.setObject(null);
        this.mutexes.remove(id);
        this.continuations.remove(id);
        return exchange;
    }

    protected void loadStaticResources() throws Exception {
    }

    protected boolean handleStaticResource(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object res;
        if (!"GET".equals(request.getMethod())) {
            return false;
        }
        String query = request.getQueryString();
        if (query != null && query.trim().equalsIgnoreCase("wsdl") && this.getResource(MAIN_WSDL) != null) {
            String uri = request.getRequestURI();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + MAIN_WSDL;
            response.sendRedirect(uri);
            return true;
        }
        String path = request.getPathInfo();
        if (path.indexOf(47) >= 0) {
            path = path.substring(path.indexOf(47) + 1);
        }
        if ((res = this.getResource(path)) == null) {
            return false;
        }
        if (res instanceof Node) {
            response.setStatus(200);
            response.setContentType("text/xml");
            try {
                new SourceTransformer().toResult((Source)new DOMSource((Node)res), (Result)new StreamResult((OutputStream)response.getOutputStream()));
            }
            catch (TransformerException e) {
                throw new ServletException("Error while sending xml resource", (Throwable)e);
            }
        } else {
            if (res != null) {
                throw new ServletException("Unable to serialize resource");
            }
            return false;
        }
        return true;
    }

    protected Object getResource(String path) {
        return this.resources.get(path);
    }

    protected void addResource(String path, Object resource) {
        this.resources.put(path, resource);
    }

    protected ContextManager getServerManager() {
        HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
        return comp.getServer();
    }

    public MessageExchange createExchange(HttpServletRequest request) throws Exception {
        MessageExchange me = this.marshaler.createExchange(request, this.getContext());
        if (me.getEndpoint() == null) {
            this.configureExchangeTarget(me);
        }
        if (request.getUserPrincipal() instanceof JaasJettyPrincipal) {
            Subject subject = ((JaasJettyPrincipal)request.getUserPrincipal()).getSubject();
            me.getMessage("in").setSecuritySubject(subject);
        }
        return me;
    }

    public void sendAccepted(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendAccepted(exchange, request, response);
    }

    public void sendError(MessageExchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendError(exchange, error, request, response);
    }

    public void sendFault(MessageExchange exchange, Fault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendFault(exchange, fault, request, response);
    }

    public void sendOut(MessageExchange exchange, NormalizedMessage outMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendOut(exchange, outMsg, request, response);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.locationURI == null || this.locationURI.trim().length() < 1) {
            throw new DeploymentException("The location URI is mandatory.");
        }
        if (this.endpoint != null && this.endpoint.contains(":")) {
            throw new DeploymentException("Endpoint name contains ':'. This character is not allowed as it can provide invalid WSDL.");
        }
        if (this.marshaler == null) {
            this.marshaler = new DefaultHttpConsumerMarshaler();
        }
        if (this.marshaler instanceof DefaultHttpConsumerMarshaler) {
            ((DefaultHttpConsumerMarshaler)this.marshaler).setDefaultMep(this.getDefaultMep());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LateResponseStrategy {
        error,
        warning;

    }
}

