/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.jetty;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.util.StringUtil;

public class SmxHttpExchange
extends HttpExchange {
    int responseStatus;
    HttpFields responseFields = new HttpFields();
    String encoding = "utf-8";
    ByteArrayOutputStream responseContent;
    int contentLength;

    public int getResponseStatus() {
        if (this.getStatus() < 5) {
            throw new IllegalStateException("Response not received");
        }
        return this.responseStatus;
    }

    public HttpFields getResponseFields() {
        if (this.getStatus() < 6) {
            throw new IllegalStateException("Headers not complete");
        }
        return this.responseFields;
    }

    public String getResponseContent() throws UnsupportedEncodingException {
        if (this.responseContent != null) {
            return this.responseContent.toString(this.encoding);
        }
        return null;
    }

    public Reader getResponseReader() throws UnsupportedEncodingException {
        if (this.responseContent != null) {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.responseContent.toByteArray()), this.encoding);
        }
        return null;
    }

    public InputStream getResponseStream() throws UnsupportedEncodingException {
        if (this.responseContent != null) {
            return new ByteArrayInputStream(this.responseContent.toByteArray());
        }
        return null;
    }

    public byte[] getResponseData() throws UnsupportedEncodingException {
        if (this.responseContent != null) {
            return this.responseContent.toByteArray();
        }
        return null;
    }

    public String getResponseEncoding() throws UnsupportedEncodingException {
        return this.encoding;
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        this.responseStatus = status;
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this.responseFields != null) {
            this.responseFields.add(name, value);
        }
        int header = HttpHeaders.CACHE.getOrdinal(value);
        switch (header) {
            case 11: {
                this.contentLength = BufferUtil.toInt((Buffer)value);
                break;
            }
            case 16: {
                String mime = StringUtil.asciiToLowerCase((String)value.toString());
                int i = mime.indexOf("charset=");
                if (i > 0 && (i = (mime = mime.substring(i + 8)).indexOf(59)) > 0) {
                    mime = mime.substring(0, i);
                }
                if (mime == null || mime.length() <= 0) break;
                this.encoding = mime;
                break;
            }
        }
    }

    protected void onResponseContent(Buffer content) throws IOException {
        if (this.responseContent == null) {
            this.responseContent = new ByteArrayOutputStream(this.contentLength);
        }
        content.writeTo((OutputStream)this.responseContent);
    }
}

