/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import java.util.Date;
import java.util.concurrent.TimeoutException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.PropertyExpression;
import org.apache.servicemix.timers.Timer;
import org.apache.servicemix.timers.TimerListener;

public class AsyncBridge
extends EIPEndpoint {
    public static final String CORRID = "org.apache.servicemix.eip.asyncbridge.corrid";
    private static final Log LOG = LogFactory.getLog(AsyncBridge.class);
    private Expression requestCorrId = new Expression(){

        public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
            return exchange.getExchangeId();
        }
    };
    private String responseCorrIdProperty = "org.apache.servicemix.eip.asyncbridge.corrid";
    private Expression responseCorrId;
    private long timeout;
    private ExchangeTarget target;
    private boolean useRobustInOnly;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public Expression getRequestCorrId() {
        return this.requestCorrId;
    }

    public void setRequestCorrId(Expression requestCorrId) {
        this.requestCorrId = requestCorrId;
    }

    public String getResponseCorrIdProperty() {
        return this.responseCorrIdProperty;
    }

    public void setResponseCorrIdProperty(String responseCorrIdProperty) {
        this.responseCorrIdProperty = responseCorrIdProperty;
    }

    public Expression getResponseCorrId() {
        return this.responseCorrId;
    }

    public void setResponseCorrId(Expression responseCorrId) {
        this.responseCorrId = responseCorrId;
    }

    public boolean isUseRobustInOnly() {
        return this.useRobustInOnly;
    }

    public void setUseRobustInOnly(boolean useRobustInOnly) {
        this.useRobustInOnly = useRobustInOnly;
    }

    public void start() throws Exception {
        super.start();
        if (this.responseCorrId == null) {
            this.responseCorrId = new PropertyExpression(this.responseCorrIdProperty);
        }
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange instanceof InOut && exchange.getStatus() == ExchangeStatus.ACTIVE) {
                MessageExchange t0 = exchange;
                String correlationId = (String)this.requestCorrId.evaluate(t0, t0.getMessage("in"));
                if (correlationId == null || correlationId.length() == 0) {
                    throw new IllegalArgumentException("Could not retrieve correlation id for incoming exchange");
                }
                this.store.store(correlationId + ".t0", (Object)t0);
                RobustInOnly t1 = this.useRobustInOnly ? this.getExchangeFactory().createRobustInOnlyExchange() : this.getExchangeFactory().createInOnlyExchange();
                this.target.configureTarget((MessageExchange)t1, this.getContext());
                MessageUtil.transferInToIn((MessageExchange)t0, (MessageExchange)t1);
                t1.setProperty(this.responseCorrIdProperty, (Object)correlationId);
                t1.getMessage("in").setProperty(this.responseCorrIdProperty, (Object)correlationId);
                this.send((MessageExchange)t1);
                return;
            } else if (exchange instanceof InOut && exchange.getStatus() != ExchangeStatus.ACTIVE) {
                MessageExchange t0 = exchange;
                String correlationId = (String)this.requestCorrId.evaluate(t0, t0.getMessage("in"));
                MessageExchange t1 = (MessageExchange)this.store.load(correlationId + ".t1");
                MessageExchange t2 = (MessageExchange)this.store.load(correlationId + ".t2");
                if (t1 != null) {
                    this.done(t1);
                }
                if (t2 == null) return;
                this.done(t2);
                return;
            } else {
                if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly) || exchange.getStatus() != ExchangeStatus.ACTIVE) throw new IllegalStateException();
                MessageExchange t2 = exchange;
                String correlationId = (String)this.responseCorrId.evaluate(t2, t2.getMessage("in"));
                if (correlationId == null || correlationId.length() == 0) {
                    throw new IllegalArgumentException("Could not retrieve correlation id for incoming exchange");
                }
                MessageExchange t0 = (MessageExchange)this.store.load(correlationId + ".t0");
                this.store.store(correlationId + ".t2", (Object)t2);
                if (t0 == null) return;
                MessageUtil.transferInToOut((MessageExchange)t2, (MessageExchange)t0);
                this.send(t0);
            }
            return;
        } else {
            MessageExchange t1 = exchange;
            final String correlationId = (String)t1.getProperty(this.responseCorrIdProperty);
            if (t1.getStatus() == ExchangeStatus.ERROR) {
                MessageExchange t0 = (MessageExchange)this.store.load(correlationId + ".t0");
                if (t0 == null) return;
                this.fail(t0, t1.getError());
                return;
            } else if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                MessageExchange t0 = (MessageExchange)this.store.load(correlationId + ".t0");
                if (t0 == null) return;
                this.store.store(correlationId + ".t1", (Object)t1);
                MessageUtil.transferFaultToFault((MessageExchange)t1, (MessageExchange)t0);
                this.send(t0);
                return;
            } else {
                Date exchangeTimeout = this.getTimeout(t1);
                if (exchangeTimeout == null) return;
                this.getTimerManager().schedule(new TimerListener(){

                    public void timerExpired(Timer timer) {
                        AsyncBridge.this.onTimeout(correlationId);
                    }
                }, exchangeTimeout);
            }
        }
    }

    protected void onTimeout(String correlationId) {
        try {
            MessageExchange t0 = (MessageExchange)this.store.load(correlationId + ".t0");
            if (t0 != null) {
                this.fail(t0, new TimeoutException());
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception caught when handling timeout", (Throwable)e);
        }
    }

    protected Date getTimeout(MessageExchange exchange) {
        if (this.timeout > 0L) {
            return new Date(System.currentTimeMillis() + this.timeout);
        }
        return null;
    }
}

