/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    private static final Log LOGGER = LogFactory.getLog(HttpServiceTracker.class);
    private Collection<HttpServiceListener> m_listeners = new ArrayList<HttpServiceListener>();
    private HttpService m_httpService;
    private Lock lock = new ReentrantLock();

    public HttpServiceTracker(BundleContext bundleContext) {
        super(HttpServiceTracker.validateBundleContext(bundleContext), HttpService.class.getName(), null);
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Bundle context cannot be null");
        }
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference serviceReference) {
        LOGGER.debug("HttpService available " + serviceReference);
        this.lock.lock();
        HttpService httpService = null;
        try {
            if (this.m_httpService != null) {
                Object object = super.addingService(serviceReference);
                return object;
            }
            httpService = this.m_httpService = (HttpService)super.addingService(serviceReference);
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.m_listeners) {
            try {
                listener.available(httpService);
            }
            catch (Exception ignore) {
                LOGGER.error("Cannot register", ignore);
            }
        }
        return httpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference serviceReference, Object service) {
        LOGGER.debug("HttpService removed " + serviceReference);
        this.lock.lock();
        HttpService httpService = null;
        try {
            super.removedService(serviceReference, service);
            if (this.m_httpService != service) {
                return;
            }
            httpService = this.m_httpService;
            this.m_httpService = null;
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.m_listeners) {
            listener.unavailable(httpService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HttpServiceListener listener) {
        this.m_listeners.add(listener);
        this.lock.lock();
        try {
            if (this.m_httpService != null) {
                try {
                    listener.available(this.m_httpService);
                }
                catch (Exception ignore) {
                    LOGGER.error("Cannot register", ignore);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HttpServiceListener listener) {
        this.m_listeners.remove(listener);
        this.lock.lock();
        try {
            if (this.m_httpService != null) {
                listener.unavailable(this.m_httpService);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

