/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class WebApplication
implements HttpServiceListener {
    private static final Log LOG = LogFactory.getLog(WebApplication.class);
    private final List<WebElement> m_webElements = new ArrayList<WebElement>();
    private final ReadWriteLock m_webElementsLock;
    private final ReadWriteLock m_httpServiceLock = new ReentrantReadWriteLock();
    private HttpContextMapping m_httpContextMapping;
    private HttpService m_httpService;
    private HttpContext m_httpContext;

    public WebApplication() {
        this.m_webElementsLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebElement(WebElement webElement) {
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.m_webElements.add(webElement);
        this.m_httpServiceLock.readLock().lock();
        try {
            this.registerWebElement(webElement);
        }
        finally {
            this.m_httpServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebElement(WebElement webElement) {
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.m_webElements.remove(webElement);
        this.m_httpServiceLock.readLock().lock();
        try {
            this.unregisterWebElement(webElement);
        }
        finally {
            this.m_httpServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void available(HttpService httpService) throws Exception {
        NullArgumentException.validateNotNull(httpService, "Http service");
        this.m_httpServiceLock.writeLock().lock();
        try {
            if (this.m_httpService != null) {
                this.unavailable(this.m_httpService);
            }
            this.m_httpService = httpService;
            this.registerHttpContext();
        }
        finally {
            this.m_httpServiceLock.writeLock().unlock();
        }
    }

    public void setHttpContextMapping(HttpContextMapping httpContextMapping) {
        if (this.m_httpContextMapping != null) {
            this.unregisterHttpContext();
        }
        this.m_httpContextMapping = httpContextMapping;
        this.registerHttpContext();
    }

    private void unregisterHttpContext() {
        if (this.m_httpContext != null) {
            this.unregisterWebElements();
            this.m_httpContext = null;
        }
    }

    private void registerHttpContext() {
        if (this.m_httpContextMapping != null && this.m_httpService != null) {
            this.m_httpContext = this.m_httpContextMapping.getHttpContext();
            if (this.m_httpContext == null) {
                this.m_httpContext = this.m_httpService.createDefaultHttpContext();
            }
            if (WebContainerUtils.isWebContainer(this.m_httpService)) {
                HashMap<String, String> contextparams = new HashMap<String, String>();
                if (this.m_httpContextMapping.getPath() != null) {
                    contextparams.put("webapp.context", this.m_httpContextMapping.getPath());
                }
                if (this.m_httpContextMapping.getParameters() != null) {
                    contextparams.putAll(this.m_httpContextMapping.getParameters());
                }
                ((WebContainer)this.m_httpService).setContextParam(DictionaryUtils.adapt(contextparams), this.m_httpContext);
            }
            this.registerWebElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWebElements() {
        this.m_webElementsLock.readLock().lock();
        try {
            if (this.m_httpService != null && this.m_httpContext != null) {
                for (WebElement registerer : this.m_webElements) {
                    this.registerWebElement(registerer);
                }
            }
        }
        finally {
            this.m_webElementsLock.readLock().unlock();
        }
    }

    private void registerWebElement(WebElement registerer) {
        try {
            if (this.m_httpService != null && this.m_httpContext != null) {
                registerer.register(this.m_httpService, this.m_httpContext);
            }
        }
        catch (Exception ignore) {
            LOG.error("Registration skipped for [" + registerer + "] due to error during registration", ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unavailable(HttpService httpService) {
        NullArgumentException.validateNotNull(httpService, "Http service");
        this.m_httpServiceLock.writeLock().lock();
        try {
            if (httpService != this.m_httpService) {
                throw new IllegalStateException("Unavailable http service [" + httpService + "] is not equal with prior available http service [" + this.m_httpService + "]");
            }
            this.unregisterWebElements();
            this.m_httpService = null;
            this.m_httpContext = null;
        }
        finally {
            this.m_httpServiceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWebElements() {
        this.m_webElementsLock.readLock().lock();
        try {
            if (this.m_httpService != null && this.m_httpContext != null) {
                for (WebElement registerer : this.m_webElements) {
                    this.unregisterWebElement(registerer);
                }
            }
        }
        finally {
            this.m_webElementsLock.readLock().unlock();
        }
    }

    private void unregisterWebElement(WebElement registerer) {
        if (this.m_httpService != null && this.m_httpContext != null) {
            registerer.unregister(this.m_httpService, this.m_httpContext);
        }
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.m_httpContextMapping).append("}").toString();
    }
}

