/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.FilterMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class FilterWebElement
implements WebElement {
    private FilterMapping m_filterMapping;

    public FilterWebElement(FilterMapping filterMapping) {
        NullArgumentException.validateNotNull(filterMapping, "Filter mapping");
        this.m_filterMapping = filterMapping;
    }

    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).registerFilter(this.m_filterMapping.getFilter(), this.m_filterMapping.getUrlPatterns(), this.m_filterMapping.getServletNames(), DictionaryUtils.adapt(this.m_filterMapping.getInitParams()), httpContext);
    }

    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).unregisterFilter(this.m_filterMapping.getFilter());
        }
    }

    public String getHttpContextId() {
        return this.m_filterMapping.getHttpContextId();
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.m_filterMapping).append("}").toString();
    }
}

