/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTracker<T, W extends WebElement>
extends ServiceTracker {
    private static final Log LOG = LogFactory.getLog(AbstractTracker.class);
    private final ExtenderContext m_extenderContext;

    AbstractTracker(ExtenderContext extenderContext, BundleContext bundleContext, Class<? extends T> ... classes) {
        super(AbstractTracker.validateBundleContext(bundleContext), AbstractTracker.createFilter(bundleContext, classes), null);
        NullArgumentException.validateNotNull(extenderContext, "Extender context");
        this.m_extenderContext = extenderContext;
    }

    private static Filter createFilter(BundleContext bundleContext, Class ... classes) {
        StringBuilder filter = new StringBuilder();
        if (classes != null) {
            if (classes.length > 1) {
                filter.append("(|");
            }
            for (Class clazz : classes) {
                filter.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
            }
            if (classes.length > 1) {
                filter.append(")");
            }
        }
        try {
            return bundleContext.createFilter(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        return bundleContext;
    }

    public Object addingService(ServiceReference serviceReference) {
        LOG.debug("Service available " + serviceReference);
        Object registered = super.addingService(serviceReference);
        W webElement = this.createWebElement(serviceReference, registered);
        if (webElement != null) {
            WebApplication webApplication = this.m_extenderContext.getWebApplication(serviceReference.getBundle(), webElement.getHttpContextId());
            webApplication.addWebElement((WebElement)webElement);
            return webElement;
        }
        super.remove(serviceReference);
        return null;
    }

    public void removedService(ServiceReference serviceReference, Object unpublished) {
        LOG.debug("Service removed " + serviceReference);
        super.removedService(serviceReference, unpublished);
        WebElement webElement = (WebElement)unpublished;
        WebApplication webApplication = this.m_extenderContext.getWebApplication(serviceReference.getBundle(), webElement.getHttpContextId());
        webApplication.removeWebElement(webElement);
    }

    abstract W createWebElement(ServiceReference var1, T var2);
}

