/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultServletMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTracker
extends AbstractTracker<Servlet, ServletWebElement> {
    private static final Log LOG = LogFactory.getLog(ServletTracker.class);

    public ServletTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext, Servlet.class, HttpServlet.class);
    }

    @Override
    ServletWebElement createWebElement(ServiceReference serviceReference, Servlet published) {
        Object httpContextId;
        Object alias = serviceReference.getProperty("alias");
        Object urlPatternsProp = serviceReference.getProperty("urlPatterns");
        String[] initParamKeys = serviceReference.getPropertyKeys();
        Object servletName = serviceReference.getProperty("servlet-name");
        if (!(servletName == null || servletName instanceof String && servletName.toString().trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid servlet-name property.");
            return null;
        }
        if (alias != null && urlPatternsProp != null) {
            LOG.warn("Registered servlet [" + published + "] cannot have both alias and url patterns");
            return null;
        }
        if (alias == null && urlPatternsProp == null) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid alias or url patterns property");
            return null;
        }
        if (!(alias == null || alias instanceof String && ((String)alias).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid alias property");
            return null;
        }
        String[] urlPatterns = null;
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String && ((String)urlPatternsProp).trim().length() != 0) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = (String[])urlPatternsProp;
            } else {
                LOG.warn("Registered servlet [" + published + "] has an invalid url pattern property (must be a non empty String or String[])");
                return null;
            }
        }
        if (!((httpContextId = serviceReference.getProperty("httpContext.id")) == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid http context id");
            return null;
        }
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String key : initParamKeys) {
            try {
                String value = serviceReference.getProperty(key) == null ? "" : serviceReference.getProperty(key).toString();
                initParams.put(key, value);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        DefaultServletMapping mapping = new DefaultServletMapping();
        mapping.setHttpContextId((String)httpContextId);
        mapping.setServlet(published);
        if (servletName != null) {
            mapping.setServletName(servletName.toString().trim());
        }
        mapping.setAlias((String)alias);
        mapping.setUrlPatterns(urlPatterns);
        mapping.setInitParams(initParams);
        return new ServletWebElement(mapping);
    }
}

