/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.servlet.SessionHandler;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServerHandlerCollection;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JettyServerWrapper
extends Server {
    private static final Log LOG = LogFactory.getLog(JettyServerWrapper.class);
    private final ServerModel m_serverModel;
    private final Map<HttpContext, Context> m_contexts;
    private Map<String, Object> m_contextAttributes;
    private Integer m_sessionTimeout;
    private String m_sessionCookie;
    private String m_sessionUrl;
    private String m_sessionWorkerName;

    JettyServerWrapper(ServerModel serverModel) {
        this.m_serverModel = serverModel;
        this.m_contexts = new IdentityHashMap<HttpContext, Context>();
    }

    public void addHandler(Handler handler) {
        if (this.getHandler() == null) {
            this.setHandler((Handler)new JettyServerHandlerCollection(this.m_serverModel));
        }
        ((HandlerCollection)this.getHandler()).addHandler(handler);
    }

    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionUrl, String sessionWorkerName) {
        this.m_contextAttributes = attributes;
        this.m_sessionTimeout = sessionTimeout;
        this.m_sessionCookie = sessionCookie;
        this.m_sessionUrl = sessionUrl;
        this.m_sessionWorkerName = sessionWorkerName;
    }

    Context getContext(HttpContext httpContext) {
        return this.m_contexts.get(httpContext);
    }

    Context getOrCreateContext(Model model) {
        Context context = this.m_contexts.get(model.getContextModel().getHttpContext());
        if (context == null) {
            context = this.addContext(model);
            this.m_contexts.put(model.getContextModel().getHttpContext(), context);
        }
        return context;
    }

    void removeContext(HttpContext httpContext) {
        this.removeHandler((Handler)this.getContext(httpContext));
        this.m_contexts.remove(httpContext);
    }

    private Context addContext(Model model) {
        String workerName;
        String sessionUrl;
        String sessionCookie;
        HttpServiceContext context = new HttpServiceContext(this, model.getContextModel().getContextParams(), this.getContextAttributes(BundleUtils.getBundleContext(model.getContextModel().getBundle())), model.getContextModel().getContextName(), model.getContextModel().getHttpContext(), model.getContextModel().getAccessControllerContext());
        context.setClassLoader(model.getContextModel().getClassLoader());
        Integer sessionTimeout = model.getContextModel().getSessionTimeout();
        if (sessionTimeout == null) {
            sessionTimeout = this.m_sessionTimeout;
        }
        if ((sessionCookie = model.getContextModel().getSessionCookie()) == null) {
            sessionCookie = this.m_sessionCookie;
        }
        if ((sessionUrl = model.getContextModel().getSessionUrl()) == null) {
            sessionUrl = this.m_sessionUrl;
        }
        if ((workerName = model.getContextModel().getSessionWorkerName()) == null) {
            workerName = this.m_sessionWorkerName;
        }
        this.configureSessionManager(context, sessionTimeout, sessionCookie, sessionUrl, workerName);
        LOG.debug("Added servlet context: " + (Object)((Object)context));
        if (this.isStarted()) {
            try {
                LOG.debug("(Re)starting servlet contexts...");
                Handler serverHandler = this.getHandler();
                if (!serverHandler.isStarted() && !serverHandler.isStarting()) {
                    serverHandler.start();
                }
                if (!context.isStarted() && !context.isStarting()) {
                    context.start();
                }
            }
            catch (Exception ignore) {
                LOG.error("Could not start the servlet context for http context [" + model.getContextModel().getHttpContext() + "]", ignore);
            }
        }
        return context;
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.m_contextAttributes != null) {
            attributes.putAll(this.m_contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    private void configureSessionManager(Context context, Integer minutes, String cookie, String url, String workerName) {
        SessionManager sessionManager;
        LOG.debug("configureSessionManager for context [" + context + "] using - timeout:" + minutes + ", cookie:" + cookie + ", url:" + url + ", workerName:" + workerName);
        SessionHandler sessionHandler = context.getSessionHandler();
        if (sessionHandler != null && (sessionManager = sessionHandler.getSessionManager()) != null) {
            if (minutes != null) {
                sessionManager.setMaxInactiveInterval(minutes * 60);
                LOG.debug("Session timeout set to " + minutes + " minutes for context [" + context + "]");
            }
            if (cookie != null) {
                sessionManager.setSessionCookie(cookie);
                LOG.debug("Session cookie set to " + cookie + " for context [" + context + "]");
            }
            if (url != null) {
                sessionManager.setSessionURL(url);
                LOG.debug("Session URL set to " + url + " for context [" + context + "]");
            }
            if (workerName != null) {
                SessionIdManager sessionIdManager = sessionManager.getIdManager();
                if (sessionIdManager == null) {
                    sessionIdManager = new HashSessionIdManager();
                    sessionManager.setIdManager(sessionIdManager);
                }
                if (sessionIdManager instanceof HashSessionIdManager) {
                    HashSessionIdManager s = (HashSessionIdManager)sessionIdManager;
                    s.setWorkerName(workerName);
                    LOG.debug("Worker name set to " + workerName + " for context [" + context + "]");
                }
            }
        }
    }
}

