/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.smpp;

import java.io.IOException;
import java.util.Date;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jbi.helper.MessageUtil;
import org.apache.servicemix.smpp.SmppEndpointType;
import org.apache.servicemix.smpp.marshaler.DefaultSmppMarshaler;
import org.apache.servicemix.smpp.marshaler.SmppMarshalerSupport;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.MessageRequest;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;

public class SmppProviderEndpoint
extends ProviderEndpoint
implements SmppEndpointType {
    private static final transient Log log = LogFactory.getLog(SmppProviderEndpoint.class);
    private static final int SMPP_DEFAULT_PORT = 2775;
    private static final String SYSTEM_TYPE = "cp";
    private SMPPSession session;
    private static TimeFormatter timeFormatter = new AbsoluteTimeFormatter();
    private String host;
    private int port;
    private String systemId;
    private String password;
    private int enquireLinkTimer = 50000;
    private int transactionTimer = 100000;
    private SmppMarshalerSupport marshaler;

    public synchronized void start() throws Exception {
        super.start();
        this.connect();
    }

    public synchronized void stop() throws Exception {
        super.stop();
        this.disconnect();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.port <= 0) {
            log.warn((Object)"Invalid SMPP port specified. Use the default one : 2775");
            this.port = 2775;
        }
        if (this.host == null || this.host.trim().length() <= 0) {
            throw new IllegalArgumentException("The SMPP host name is mandatory.");
        }
        if (this.systemId == null || this.systemId.trim().length() <= 0) {
            throw new IllegalArgumentException("The SMPP system ID is mandatory.");
        }
        if (this.marshaler == null) {
            this.marshaler = new DefaultSmppMarshaler();
        }
        if (this.enquireLinkTimer <= 0) {
            throw new IllegalArgumentException("The enquireLinkTimer value must be greater than 0.");
        }
        if (this.transactionTimer <= 0) {
            throw new IllegalArgumentException("The transactionTimer value must be greater than 0.");
        }
    }

    private void connect() {
        this.session = new SMPPSession();
        this.session.setEnquireLinkTimer(this.enquireLinkTimer);
        this.session.setTransactionTimer((long)this.transactionTimer);
        try {
            this.session.connectAndBind(this.host, this.port, new BindParameter(BindType.BIND_TX, this.systemId, this.password, SYSTEM_TYPE, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
        }
        catch (IOException ioException) {
            log.error((Object)"Error connecting to the SMPP server", (Throwable)ioException);
            return;
        }
    }

    private void disconnect() {
        if (this.session == null) {
            return;
        }
        this.session.unbindAndClose();
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage inMsg) throws Exception {
        this.process(exchange, inMsg);
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        MessageUtil.enableContentRereadability((NormalizedMessage)in);
        this.process(exchange, in);
        MessageUtil.transfer((NormalizedMessage)in, (NormalizedMessage)out);
    }

    private void process(MessageExchange exchange, NormalizedMessage in) throws TransformerException, MessagingException {
        MessageRequest sm = this.marshaler.fromNMS(exchange, in);
        try {
            log.debug((Object)("Submiting request: " + sm));
            String messageId = this.session.submitShortMessage("CMT", TypeOfNumber.valueOf((byte)sm.getSourceAddrTon()), NumberingPlanIndicator.valueOf((byte)sm.getSourceAddrNpi()), sm.getSourceAddr(), TypeOfNumber.valueOf((byte)sm.getDestAddrTon()), NumberingPlanIndicator.valueOf((byte)sm.getDestAddrNpi()), sm.getDestAddress(), new ESMClass(), (byte)0, (byte)1, timeFormatter.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, (DataCoding)new GeneralDataCoding(false, false, MessageClass.CLASS1, Alphabet.ALPHA_DEFAULT), (byte)0, sm.getShortMessage(), new OptionalParameter[0]);
            log.debug((Object)("Message sent with ID " + messageId));
        }
        catch (PDUException pduException) {
            log.error((Object)"Invalid PDU parameter", (Throwable)pduException);
            this.fail(exchange, new Exception("Invalid PDU parameter", pduException));
        }
        catch (ResponseTimeoutException responseTimeoutException) {
            log.error((Object)"Response timeout");
            this.fail(exchange, new Exception("Response timeout", responseTimeoutException));
        }
        catch (InvalidResponseException invalidResponseException) {
            log.error((Object)"Invalid response");
            this.fail(exchange, new Exception("Invalid response", invalidResponseException));
        }
        catch (NegativeResponseException negativeResponseException) {
            log.error((Object)"Negative response");
            this.fail(exchange, new Exception("Negative response", negativeResponseException));
        }
        catch (IOException ioException) {
            log.error((Object)"IO error during message send");
            this.fail(exchange, new Exception("IO error during message send", ioException));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SmppMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(SmppMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public int getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    public void setEnquireLinkTimer(int enquireLinkTimer) {
        this.enquireLinkTimer = enquireLinkTimer;
    }

    public int getTransactionTimer() {
        return this.transactionTimer;
    }

    public void setTransactionTimer(int transactionTimer) {
        this.transactionTimer = transactionTimer;
    }
}

