/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.smpp.marshaler;

import java.util.ArrayList;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.smpp.marshaler.SmppMarshalerSupport;
import org.jsmpp.bean.MessageRequest;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DefaultSmppMarshaler
implements SmppMarshalerSupport {
    private static final transient Log log = LogFactory.getLog(DefaultSmppMarshaler.class);
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_DESTINATION = "destination";
    private static final String TAG_TEXT = "text";
    private static final String TAG_TON = "ton";
    private static final String TAG_NPI = "npi";
    private static final String TAG_REGISTERED_DELIVERY = "registeredDelivery";
    private static final String TAG_SCHEDULE_DELIVERY_TIME = "scheduleDeliveryTime";
    private static final String TAG_VALIDITY_PERIOD = "validityPeriod";
    private static final String DEST_ADDR_SUBUNIT = "DEST_ADDR_SUBUNIT";
    private static final String DEST_NETWORK_TYPE = "DEST_NETWORK_TYPE";
    private static final String DEST_BEARER_TYPE = "DEST_BEARER_TYPE";
    private static final String DEST_TELEMATICS_ID = "DEST_TELEMATICS_ID";
    private static final String SOURCE_ADDR_SUBUNIT = "SOURCE_ADDR_SUBUNIT";
    private static final String SOURCE_NETWORK_TYPE = "SOURCE_NETWORK_TYPE";
    private static final String SOURCE_BEARER_TYPE = "SOURCE_BEARER_TYPE";
    private static final String SOURCE_TELEMATICS_ID = "SOURCE_TELEMATICS_ID";
    private static final String QOS_TIME_TO_LIVE = "QOS_TIME_TO_LIVE";
    private static final String PAYLOAD_TYPE = "PAYLOAD_TYPE";
    private static final String ADDITIONAL_STATUS_INFO_TEXT = "ADDITIONAL_STATUS_INFO_TEXT";
    private static final String RECEIPTED_MESSAGE_ID = "RECEIPTED_MESSAGE_ID";
    private static final String MS_MSG_WAIT_FACILITIES = "MS_MSG_WAIT_FACILITIES";
    private static final String PRIVACY_INDICATOR = "PRIVACY_INDICATOR";
    private static final String SOURCE_SUBADDRESS = "SOURCE_SUBADDRESS";
    private static final String DEST_SUBADDRESS = "DEST_SUBADDRESS";
    private static final String USER_MESSAGE_REFERENCE = "USER_MESSAGE_REFERENCE";
    private static final String USER_RESPONSE_CODE = "USER_RESPONSE_CODE";
    private static final String SOURCE_PORT = "SOURCE_PORT";
    private static final String DESTINATION_PORT = "DESTINATION_PORT";
    private static final String SAR_MSG_REF_NUM = "SAR_MSG_REF_NUM";
    private static final String LANGUAGE_INDICATOR = "LANGUAGE_INDICATOR";
    private static final String SAR_TOTAL_SEGMENTS = "SAR_TOTAL_SEGMENTS";
    private static final String SAR_SEGMENT_SEQNUM = "SAR_SEGMENT_SEQNUM";
    private static final String SC_INTERFACE_VERSION = "SC_INTERFACE_VERSION";
    private static final String CALLBACK_NUM_PRES_IND = "CALLBACK_NUM_PRES_IND";
    private static final String CALLBACK_NUM_ATAG = "CALLBACK_NUM_ATAG";
    private static final String NUMBER_OF_MESSAGES = "NUMBER_OF_MESSAGES";
    private static final String CALLBACK_NUM = "CALLBACK_NUM";
    private static final String DPF_RESULT = "DPF_RESULT";
    private static final String SET_DPF = "SET_DPF";
    private static final String MS_AVAILABILITY_STATUS = "MS_AVAILABILITY_STATUS";
    private static final String NETWORK_ERROR_CODE = "NETWORK_ERROR_CODE";
    private static final String MESSAGE_PAYLOAD = "MESSAGE_PAYLOAD";
    private static final String DELIVERY_FAILURE_REASON = "DELIVERY_FAILURE_REASON";
    private static final String MORE_MESSAGES_TO_SEND = "MORE_MESSAGES_TO_SEND";
    private static final String MESSAGE_STATE = "MESSAGE_STATE";
    private static final String USSD_SERVICE_OP = "USSD_SERVICE_OP";
    private static final String DISPLAY_TIME = "DISPLAY_TIME";
    private static final String SMS_SIGNAL = "SMS_SIGNAL";
    private static final String MS_VALIDITY = "MS_VALIDITY";
    private static final String ALERT_ON_MESSAGE_DELIVERY = "ALERT_ON_MESSAGE_DELIVERY";
    private static final String ITS_REPLY_TYPE = "ITS_REPLY_TYPE";
    private static final String ITS_SESSION_INFO = "ITS_SESSION_INFO";
    private static final String TAG_MESSAGE_OPEN = "<message>";
    private static final String TAG_MESSAGE_CLOSE = "</message>";
    private static final String TAG_SOURCE_OPEN = "<source>";
    private static final String TAG_SOURCE_CLOSE = "</source>";
    private static final String TAG_DESTINATION_OPEN = "<destination>";
    private static final String TAG_DESTINATION_CLOSE = "</destination>";
    private static final String TAG_TEXT_OPEN = "<text>";
    private static final String TAG_TEXT_CLOSE = "</text>";
    private static final String TAG_TON_OPEN = "<ton>";
    private static final String TAG_TON_CLOSE = "</ton>";
    private static final String TAG_NPI_OPEN = "<npi>";
    private static final String TAG_NPI_CLOSE = "</npi>";
    private static final String TAG_REGISTERED_DELIVERY_OPEN = "<registeredDelivery>";
    private static final String TAG_REGISTERED_DELIVERY_CLOSE = "</registeredDelivery>";
    private static final String TAG_SCHEDULE_DELIVERY_TIME_OPEN = "<scheduleDeliveryTime>";
    private static final String TAG_SCHEDULE_DELIVERY_TIME_CLOSE = "</scheduleDeliveryTime>";
    private static final String TAG_VALIDITY_PERIOD_OPEN = "<validityPeriod>";
    private static final String TAG_VALIDITY_PERIOD_CLOSE = "</validityPeriod>";
    private SourceTransformer transformer = new SourceTransformer();

    public MessageRequest fromNMS(MessageExchange exchange, NormalizedMessage message) throws TransformerException {
        SubmitSm sm = new SubmitSm();
        String ton = null;
        String npi = null;
        try {
            Document document = this.transformer.toDOMDocument(message);
            document.getDocumentElement().normalize();
            NodeList node = null;
            node = this.getNotEmptyNodeListOrNull(document, TAG_SOURCE);
            if (node != null) {
                sm.setSourceAddr(this.getFirstNodeValue(node));
                log.debug((Object)("source: " + sm.getSourceAddr()));
            }
            if ((node = this.getNotEmptyNodeListOrNull(document, TAG_DESTINATION)) != null) {
                sm.setDestAddress(this.getFirstNodeValue(node));
                log.debug((Object)("destination: " + sm.getDestAddress()));
            }
            if ((node = this.getNotEmptyNodeListOrNull(document, TAG_TEXT)) != null) {
                sm.setShortMessage(this.getFirstNodeValue(node).getBytes());
                log.debug((Object)("text: " + new String(sm.getShortMessage())));
            }
            if ((node = this.getNotEmptyNodeListOrNull(document, TAG_TON)) != null) {
                ton = this.getFirstNodeValue(node);
                sm.setDestAddrTon(TypeOfNumber.valueOf((String)ton).value());
                sm.setSourceAddrTon(TypeOfNumber.valueOf((String)ton).value());
                log.debug((Object)("ton: " + ton));
            }
            if ((node = this.getNotEmptyNodeListOrNull(document, TAG_NPI)) != null) {
                npi = this.getFirstNodeValue(node);
                sm.setDestAddrNpi(NumberingPlanIndicator.valueOf((String)npi).value());
                sm.setSourceAddrNpi(NumberingPlanIndicator.valueOf((String)npi).value());
                log.debug((Object)("npi: " + npi));
            }
            if ((node = this.getNotEmptyNodeListOrNull(document, TAG_REGISTERED_DELIVERY)) != null) {
                String registeredDelivery = this.getFirstNodeValue(node);
                sm.setRegisteredDelivery(SMSCDeliveryReceipt.valueOf((String)registeredDelivery).value());
                log.debug((Object)("registeredDelivery: " + registeredDelivery));
            } else {
                sm.setRegisteredDelivery(SMSCDeliveryReceipt.DEFAULT.value());
                log.debug((Object)"registeredDelivery: DEFAULT");
            }
            node = this.getNotEmptyNodeListOrNull(document, TAG_SCHEDULE_DELIVERY_TIME);
            if (node != null) {
                sm.setScheduleDeliveryTime(this.getFirstNodeValue(node));
                log.debug((Object)("scheduleDeliveryTime: " + sm.getScheduleDeliveryTime()));
            }
            if ((node = this.getNotEmptyNodeListOrNull(document, TAG_VALIDITY_PERIOD)) != null) {
                sm.setValidityPeriod(this.getFirstNodeValue(node));
                log.debug((Object)("validityPeriod: " + sm.getValidityPeriod()));
            }
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
        if (sm.getSourceAddr() == null) {
            throw new TransformerException("Invalid message content. Missing tag: source");
        }
        if (sm.getDestAddress() == null) {
            throw new TransformerException("Invalid message content. Missing tag: destination");
        }
        if (ton == null) {
            throw new TransformerException("Invalid message content. Missing tag: ton");
        }
        if (npi == null) {
            throw new TransformerException("Invalid message content. Missing tag: npi");
        }
        this.applyOptionalParametersToRequest((MessageRequest)sm, message);
        return sm;
    }

    public void toNMS(NormalizedMessage message, MessageRequest mr) throws MessagingException {
        if (message == null) {
            throw new MessagingException("The NormalizedMessage is null");
        }
        if (mr == null) {
            throw new MessagingException("The MessageRequest is null");
        }
        if (mr.getSourceAddr() == null || mr.getSourceAddr().trim().length() < 1) {
            log.error((Object)"The MessageRequest source address is not defined");
            throw new MessagingException("The MessageRequest source address is not defined");
        }
        if (mr.getDestAddress() == null || mr.getDestAddress().trim().length() < 1) {
            log.error((Object)"The MessageRequest destination address is not defined");
            throw new MessagingException("The MessageRequest destination address is not defined");
        }
        try {
            NumberingPlanIndicator.valueOf((byte)mr.getDestAddrNpi());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)"The MessageRequest destination numbering plan indicator is not valid");
            throw new MessagingException("The MessageRequest destination numbering plan indicator is not valid");
        }
        try {
            TypeOfNumber.valueOf((byte)mr.getDestAddrTon());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)"The MessageRequest destination type of number is not valid");
            throw new MessagingException("The MessageRequest destination type of number is not valid");
        }
        try {
            this.determineSMSCDeliveryReceipt(mr.getRegisteredDelivery());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error((Object)"The MessageRequest registered delivery is not valid");
            throw new MessagingException("The MessageRequest registered delivery is not valid");
        }
        if (mr.getShortMessage() == null || mr.getShortMessage().length == 0) {
            log.warn((Object)"Received message without text content. Ignore the message");
            return;
        }
        StringBuffer data = new StringBuffer();
        data.append(TAG_MESSAGE_OPEN);
        data.append(TAG_SOURCE_OPEN);
        data.append(mr.getSourceAddr());
        data.append(TAG_SOURCE_CLOSE);
        data.append(TAG_DESTINATION_OPEN);
        data.append(mr.getDestAddress());
        data.append(TAG_DESTINATION_CLOSE);
        data.append(TAG_TEXT_OPEN);
        data.append(new String(mr.getShortMessage()));
        data.append(TAG_TEXT_CLOSE);
        data.append(TAG_NPI_OPEN);
        data.append(NumberingPlanIndicator.valueOf((byte)mr.getDestAddrNpi()).toString());
        data.append(TAG_NPI_CLOSE);
        data.append(TAG_TON_OPEN);
        data.append(TypeOfNumber.valueOf((byte)mr.getDestAddrTon()).toString());
        data.append(TAG_TON_CLOSE);
        data.append(TAG_REGISTERED_DELIVERY_OPEN);
        data.append(this.determineSMSCDeliveryReceipt(mr.getRegisteredDelivery()).toString());
        data.append(TAG_REGISTERED_DELIVERY_CLOSE);
        if (mr.getScheduleDeliveryTime() != null && mr.getScheduleDeliveryTime().trim().length() > 0) {
            data.append(TAG_SCHEDULE_DELIVERY_TIME_OPEN);
            data.append(mr.getScheduleDeliveryTime());
            data.append(TAG_SCHEDULE_DELIVERY_TIME_CLOSE);
        }
        if (mr.getValidityPeriod() != null && mr.getValidityPeriod().trim().length() > 0) {
            data.append(TAG_VALIDITY_PERIOD_OPEN);
            data.append(mr.getValidityPeriod());
            data.append(TAG_VALIDITY_PERIOD_CLOSE);
        }
        data.append(TAG_MESSAGE_CLOSE);
        message.setContent((Source)new StringSource(data.toString()));
        this.applyOptionalParametersToNormalizedMessage(mr, message);
    }

    private void applyOptionalParametersToNormalizedMessage(MessageRequest request, NormalizedMessage message) {
        OptionalParameter[] optionalParameter = request.getOptionalParametes();
        if (optionalParameter != null) {
            for (int i = 0; i < optionalParameter.length; ++i) {
                OptionalParameter.Byte parameter;
                String name = OptionalParameter.Tag.valueOf((short)optionalParameter[i].tag).name();
                if (optionalParameter[i] instanceof OptionalParameter.Byte) {
                    parameter = (OptionalParameter.Byte)optionalParameter[i];
                    message.setProperty(name, (Object)parameter.getValue());
                    continue;
                }
                if (optionalParameter[i] instanceof OptionalParameter.Short) {
                    parameter = (OptionalParameter.Short)optionalParameter[i];
                    message.setProperty(name, (Object)parameter.getValue());
                    continue;
                }
                if (optionalParameter[i] instanceof OptionalParameter.Int) {
                    parameter = (OptionalParameter.Int)optionalParameter[i];
                    message.setProperty(name, (Object)parameter.getValue());
                    continue;
                }
                if (optionalParameter[i] instanceof OptionalParameter.COctetString) {
                    parameter = (OptionalParameter.COctetString)optionalParameter[i];
                    message.setProperty(name, (Object)parameter.getValueAsString());
                    continue;
                }
                if (!(optionalParameter[i] instanceof OptionalParameter.Null)) continue;
                OptionalParameter.Null paramter = (OptionalParameter.Null)optionalParameter[i];
                message.setProperty(name, (Object)"");
            }
        }
    }

    private void applyOptionalParametersToRequest(MessageRequest request, NormalizedMessage message) {
        Object itsSessionInfo;
        Object itsReplyType;
        Object msValidity;
        Object alertOnMessageDelivery;
        Object smsSignal;
        Object displayTime;
        Object ussdServiceOP;
        Object messageState;
        Object moreMessagesToSent;
        Object deliveryFailureReason;
        Object messagePayload;
        Object networkErrorCode;
        Object msAvailabilityStatus;
        Object setDpf;
        Object dpfResult;
        Object callbackNum;
        Object numberOfMessages;
        Object callbackNumAtag;
        Object callbackNumPresInd;
        Object scInterfaceVersion;
        Object sarSegmentSeqNum;
        Object sarTotalSegments;
        Object languageIndicator;
        Object sarMsgRefNum;
        Object desitinationPort;
        Object sourcePort;
        Object userResponseCode;
        Object userMessageReference;
        Object destSubAddress;
        Object sourceSubAddress;
        Object privacyIndicator;
        Object msMsgWaitFacilities;
        Object recipientMessageId;
        Object additionalStatusInfoText;
        Object payloadType;
        Object qosTimeToLive;
        Object sourceTelematicsId;
        Object sourceBearerType;
        Object sourceNetworkType;
        Object sourceAddrSubunit;
        Object destTelematicsId;
        Object destBearerType;
        Object destNetworkType;
        ArrayList<Object> optionalParameters = new ArrayList<Object>();
        Object destAddressSubunit = message.getProperty(DEST_ADDR_SUBUNIT);
        if (destAddressSubunit != null) {
            if (destAddressSubunit instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DEST_ADDR_SUBUNIT, ((Byte)destAddressSubunit).byteValue()));
            } else if (destAddressSubunit instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DEST_ADDR_SUBUNIT, Byte.valueOf((String)destAddressSubunit).byteValue()));
            }
        }
        if ((destNetworkType = message.getProperty(DEST_NETWORK_TYPE)) != null) {
            if (destNetworkType instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DEST_NETWORK_TYPE, ((Byte)destNetworkType).byteValue()));
            } else if (destNetworkType instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DEST_NETWORK_TYPE, Byte.valueOf((String)destNetworkType).byteValue()));
            }
        }
        if ((destBearerType = message.getProperty(DEST_BEARER_TYPE)) != null) {
            if (destBearerType instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DEST_BEARER_TYPE, ((Byte)destBearerType).byteValue()));
            } else if (destBearerType instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DEST_BEARER_TYPE, Byte.valueOf((String)destBearerType).byteValue()));
            }
        }
        if ((destTelematicsId = message.getProperty(DEST_TELEMATICS_ID)) != null) {
            if (destTelematicsId instanceof Short) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.DEST_TELEMATICS_ID, ((Short)destTelematicsId).shortValue()));
            } else if (destTelematicsId instanceof String) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.DEST_TELEMATICS_ID, Short.valueOf((String)destTelematicsId).shortValue()));
            }
        }
        if ((sourceAddrSubunit = message.getProperty(SOURCE_ADDR_SUBUNIT)) != null) {
            if (sourceAddrSubunit instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_ADDR_SUBUNIT, ((Byte)sourceAddrSubunit).byteValue()));
            } else if (sourceAddrSubunit instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_ADDR_SUBUNIT, Byte.valueOf((String)sourceAddrSubunit).byteValue()));
            }
        }
        if ((sourceNetworkType = message.getProperty(SOURCE_NETWORK_TYPE)) != null) {
            if (sourceNetworkType instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_NETWORK_TYPE, ((Byte)sourceNetworkType).byteValue()));
            } else if (sourceNetworkType instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_NETWORK_TYPE, Byte.valueOf((String)sourceNetworkType).byteValue()));
            }
        }
        if ((sourceBearerType = message.getProperty(SOURCE_BEARER_TYPE)) != null) {
            if (sourceBearerType instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_BEARER_TYPE, ((Byte)sourceBearerType).byteValue()));
            } else if (sourceBearerType instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_BEARER_TYPE, Byte.valueOf((String)sourceBearerType).byteValue()));
            }
        }
        if ((sourceTelematicsId = message.getProperty(SOURCE_TELEMATICS_ID)) != null) {
            if (sourceTelematicsId instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_TELEMATICS_ID, ((Byte)sourceTelematicsId).byteValue()));
            } else if (sourceTelematicsId instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SOURCE_TELEMATICS_ID, Byte.valueOf((String)sourceTelematicsId).byteValue()));
            }
        }
        if ((qosTimeToLive = message.getProperty(QOS_TIME_TO_LIVE)) != null) {
            if (qosTimeToLive instanceof Integer) {
                optionalParameters.add(new OptionalParameter.Int(OptionalParameter.Tag.QOS_TIME_TO_LIVE, ((Integer)qosTimeToLive).intValue()));
            } else if (qosTimeToLive instanceof String) {
                optionalParameters.add(new OptionalParameter.Int(OptionalParameter.Tag.QOS_TIME_TO_LIVE, Integer.valueOf((String)qosTimeToLive).intValue()));
            }
        }
        if ((payloadType = message.getProperty(PAYLOAD_TYPE)) != null) {
            if (payloadType instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.PAYLOAD_TYPE, ((Byte)payloadType).byteValue()));
            } else if (payloadType instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.PAYLOAD_TYPE, Byte.valueOf((String)payloadType).byteValue()));
            }
        }
        if ((additionalStatusInfoText = message.getProperty(ADDITIONAL_STATUS_INFO_TEXT)) != null && additionalStatusInfoText instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.ADDITIONAL_STATUS_INFO_TEXT.code(), (String)additionalStatusInfoText));
        }
        if ((recipientMessageId = message.getProperty(RECEIPTED_MESSAGE_ID)) != null && recipientMessageId instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.RECEIPTED_MESSAGE_ID.code(), (String)recipientMessageId));
        }
        if ((msMsgWaitFacilities = message.getProperty(MS_MSG_WAIT_FACILITIES)) != null) {
            if (msMsgWaitFacilities instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MS_MSG_WAIT_FACILITIES, ((Byte)msMsgWaitFacilities).byteValue()));
            } else if (msMsgWaitFacilities instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MS_MSG_WAIT_FACILITIES, Byte.valueOf((String)msMsgWaitFacilities).byteValue()));
            }
        }
        if ((privacyIndicator = message.getProperty(PRIVACY_INDICATOR)) != null) {
            if (privacyIndicator instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.PRIVACY_INDICATOR, ((Byte)privacyIndicator).byteValue()));
            } else if (privacyIndicator instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.PRIVACY_INDICATOR, Byte.valueOf((String)privacyIndicator).byteValue()));
            }
        }
        if ((sourceSubAddress = message.getProperty(SOURCE_SUBADDRESS)) != null && sourceSubAddress instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.SOURCE_SUBADDRESS.code(), (String)sourceSubAddress));
        }
        if ((destSubAddress = message.getProperty(DEST_SUBADDRESS)) != null && destSubAddress instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.DEST_SUBADDRESS.code(), (String)destSubAddress));
        }
        if ((userMessageReference = message.getProperty(USER_MESSAGE_REFERENCE)) != null) {
            if (userMessageReference instanceof Short) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.USER_MESSAGE_REFERENCE, ((Short)userMessageReference).shortValue()));
            } else if (userMessageReference instanceof String) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.USER_MESSAGE_REFERENCE, Short.valueOf((String)userMessageReference).shortValue()));
            }
        }
        if ((userResponseCode = message.getProperty(USER_RESPONSE_CODE)) != null) {
            if (userResponseCode instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.USER_RESPONSE_CODE, ((Byte)userResponseCode).byteValue()));
            } else if (userResponseCode instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.USER_RESPONSE_CODE, Byte.valueOf((String)userResponseCode).byteValue()));
            }
        }
        if ((sourcePort = message.getProperty(SOURCE_PORT)) != null) {
            if (sourcePort instanceof Short) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.SOURCE_PORT, ((Short)sourcePort).shortValue()));
            } else if (sourcePort instanceof String) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.SOURCE_PORT, Short.valueOf((String)sourcePort).shortValue()));
            }
        }
        if ((desitinationPort = message.getProperty(DESTINATION_PORT)) != null) {
            if (desitinationPort instanceof Short) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.DESTINATION_PORT, ((Short)desitinationPort).shortValue()));
            } else if (desitinationPort instanceof String) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.DESTINATION_PORT, Short.valueOf((String)desitinationPort).shortValue()));
            }
        }
        if ((sarMsgRefNum = message.getProperty(SAR_MSG_REF_NUM)) != null) {
            if (sarMsgRefNum instanceof Short) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.SAR_MSG_REF_NUM, ((Short)sarMsgRefNum).shortValue()));
            } else if (sarMsgRefNum instanceof String) {
                optionalParameters.add(new OptionalParameter.Short(OptionalParameter.Tag.SAR_MSG_REF_NUM, Short.valueOf((String)sarMsgRefNum).shortValue()));
            }
        }
        if ((languageIndicator = message.getProperty(LANGUAGE_INDICATOR)) != null) {
            if (languageIndicator instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.LANGUAGE_INDICATOR, ((Byte)languageIndicator).byteValue()));
            } else if (languageIndicator instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.LANGUAGE_INDICATOR, Byte.valueOf((String)languageIndicator).byteValue()));
            }
        }
        if ((sarTotalSegments = message.getProperty(SAR_TOTAL_SEGMENTS)) != null) {
            if (sarTotalSegments instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SAR_TOTAL_SEGMENTS, ((Byte)sarTotalSegments).byteValue()));
            } else if (sarTotalSegments instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SAR_TOTAL_SEGMENTS, Byte.valueOf((String)sarTotalSegments).byteValue()));
            }
        }
        if ((sarSegmentSeqNum = message.getProperty(SAR_SEGMENT_SEQNUM)) != null) {
            if (sarSegmentSeqNum instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SAR_SEGMENT_SEQNUM, ((Byte)sarSegmentSeqNum).byteValue()));
            } else if (sarSegmentSeqNum instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SAR_SEGMENT_SEQNUM, Byte.valueOf((String)sarSegmentSeqNum).byteValue()));
            }
        }
        if ((scInterfaceVersion = message.getProperty(SC_INTERFACE_VERSION)) != null) {
            if (scInterfaceVersion instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SC_INTERFACE_VERSION, ((Byte)scInterfaceVersion).byteValue()));
            } else if (scInterfaceVersion instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SC_INTERFACE_VERSION, Byte.valueOf((String)scInterfaceVersion).byteValue()));
            }
        }
        if ((callbackNumPresInd = message.getProperty(CALLBACK_NUM_PRES_IND)) != null) {
            if (callbackNumPresInd instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.CALLBACK_NUM_PRES_IND, ((Byte)callbackNumPresInd).byteValue()));
            } else if (callbackNumPresInd instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.CALLBACK_NUM_PRES_IND, Byte.valueOf((String)callbackNumPresInd).byteValue()));
            }
        }
        if ((callbackNumAtag = message.getProperty(CALLBACK_NUM_ATAG)) != null && callbackNumAtag instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.CALLBACK_NUM_ATAG.code(), (String)callbackNumAtag));
        }
        if ((numberOfMessages = message.getProperty(NUMBER_OF_MESSAGES)) != null) {
            if (numberOfMessages instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.NUMBER_OF_MESSAGES, ((Byte)numberOfMessages).byteValue()));
            } else if (numberOfMessages instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.NUMBER_OF_MESSAGES, Byte.valueOf((String)numberOfMessages).byteValue()));
            }
        }
        if ((callbackNum = message.getProperty(CALLBACK_NUM)) != null && callbackNum instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.CALLBACK_NUM.code(), (String)callbackNum));
        }
        if ((dpfResult = message.getProperty(DPF_RESULT)) != null) {
            if (dpfResult instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DPF_RESULT, ((Byte)dpfResult).byteValue()));
            } else if (dpfResult instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DPF_RESULT, Byte.valueOf((String)dpfResult).byteValue()));
            }
        }
        if ((setDpf = message.getProperty(SET_DPF)) != null) {
            if (setDpf instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SET_DPF, ((Byte)setDpf).byteValue()));
            } else if (setDpf instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SET_DPF, Byte.valueOf((String)setDpf).byteValue()));
            }
        }
        if ((msAvailabilityStatus = message.getProperty(MS_AVAILABILITY_STATUS)) != null) {
            if (msAvailabilityStatus instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MS_AVAILABILITY_STATUS, ((Byte)msAvailabilityStatus).byteValue()));
            } else if (msAvailabilityStatus instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MS_AVAILABILITY_STATUS, Byte.valueOf((String)msAvailabilityStatus).byteValue()));
            }
        }
        if ((networkErrorCode = message.getProperty(NETWORK_ERROR_CODE)) != null && networkErrorCode instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.NETWORK_ERROR_CODE.code(), (String)networkErrorCode));
        }
        if ((messagePayload = message.getProperty(MESSAGE_PAYLOAD)) != null && messagePayload instanceof String) {
            optionalParameters.add(new OptionalParameter.COctetString(OptionalParameter.Tag.MESSAGE_PAYLOAD.code(), (String)messagePayload));
        }
        if ((deliveryFailureReason = message.getProperty(DELIVERY_FAILURE_REASON)) != null) {
            if (deliveryFailureReason instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DELIVERY_FAILURE_REASON, ((Byte)deliveryFailureReason).byteValue()));
            } else if (deliveryFailureReason instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DELIVERY_FAILURE_REASON, Byte.valueOf((String)deliveryFailureReason).byteValue()));
            }
        }
        if ((moreMessagesToSent = message.getProperty(MORE_MESSAGES_TO_SEND)) != null) {
            if (moreMessagesToSent instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MORE_MESSAGES_TO_SEND, ((Byte)moreMessagesToSent).byteValue()));
            } else if (moreMessagesToSent instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MORE_MESSAGES_TO_SEND, Byte.valueOf((String)moreMessagesToSent).byteValue()));
            }
        }
        if ((messageState = message.getProperty(MESSAGE_STATE)) != null) {
            if (messageState instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MESSAGE_STATE, ((Byte)messageState).byteValue()));
            } else if (messageState instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MESSAGE_STATE, Byte.valueOf((String)messageState).byteValue()));
            }
        }
        if ((ussdServiceOP = message.getProperty(USSD_SERVICE_OP)) != null) {
            if (ussdServiceOP instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.USSD_SERVICE_OP, ((Byte)ussdServiceOP).byteValue()));
            } else if (ussdServiceOP instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.USSD_SERVICE_OP, Byte.valueOf((String)ussdServiceOP).byteValue()));
            }
        }
        if ((displayTime = message.getProperty(DISPLAY_TIME)) != null) {
            if (displayTime instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DISPLAY_TIME, ((Byte)displayTime).byteValue()));
            } else if (displayTime instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.DISPLAY_TIME, Byte.valueOf((String)displayTime).byteValue()));
            }
        }
        if ((smsSignal = message.getProperty(SMS_SIGNAL)) != null) {
            if (smsSignal instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SMS_SIGNAL, ((Byte)smsSignal).byteValue()));
            } else if (smsSignal instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.SMS_SIGNAL, Byte.valueOf((String)smsSignal).byteValue()));
            }
        }
        if ((alertOnMessageDelivery = message.getProperty(ALERT_ON_MESSAGE_DELIVERY)) != null) {
            optionalParameters.add(new OptionalParameter.Null(OptionalParameter.Tag.ALERT_ON_MESSAGE_DELIVERY));
        }
        if ((msValidity = message.getProperty(MS_VALIDITY)) != null) {
            if (msValidity instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MS_VALIDITY, ((Byte)msValidity).byteValue()));
            } else if (msValidity instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.MS_VALIDITY, Byte.valueOf((String)msValidity).byteValue()));
            }
        }
        if ((itsReplyType = message.getProperty(ITS_REPLY_TYPE)) != null) {
            if (itsReplyType instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.ITS_REPLY_TYPE, ((Byte)itsReplyType).byteValue()));
            } else if (itsReplyType instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.ITS_REPLY_TYPE, Byte.valueOf((String)itsReplyType).byteValue()));
            }
        }
        if ((itsSessionInfo = message.getProperty(ITS_SESSION_INFO)) != null) {
            if (itsSessionInfo instanceof Byte) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.ITS_SESSION_INFO, ((Byte)itsSessionInfo).byteValue()));
            } else if (itsSessionInfo instanceof String) {
                optionalParameters.add(new OptionalParameter.Byte(OptionalParameter.Tag.ITS_SESSION_INFO, Byte.valueOf((String)itsSessionInfo).byteValue()));
            }
        }
        if (!optionalParameters.isEmpty()) {
            request.setOptionalParametes(optionalParameters.toArray(new OptionalParameter[optionalParameters.size()]));
        }
    }

    private String getFirstNodeValue(NodeList node) {
        return node.item(0).getChildNodes().item(0).getNodeValue();
    }

    private NodeList getNotEmptyNodeListOrNull(Document document, String nodeName) {
        NodeList node = document.getElementsByTagName(nodeName);
        return node != null && node.getLength() > 0 ? node : null;
    }

    private SMSCDeliveryReceipt determineSMSCDeliveryReceipt(byte value) {
        for (SMSCDeliveryReceipt val : SMSCDeliveryReceipt.values()) {
            if (val.value() != value) continue;
            return val;
        }
        throw new IllegalArgumentException("No enum const SMSCDeliveryReceipt with value " + value);
    }
}

