/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.gsm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class IMEICondition {
    private static final String ORG_OSGI_UTIL_GSM_IMEI = "org.osgi.util.gsm.imei";
    private static final String imei = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty(IMEICondition.ORG_OSGI_UTIL_GSM_IMEI);
        }
    });

    private IMEICondition() {
    }

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        if (bundle == null) {
            throw new NullPointerException("bundle");
        }
        String imei = conditionInfo.getArgs()[0];
        if (imei.length() > 15) {
            throw new IllegalArgumentException("imei too long: " + imei);
        }
        if (imei.endsWith("*")) {
            imei = imei.substring(0, imei.length() - 1);
        } else if (imei.length() != 15) {
            throw new IllegalArgumentException("not a valid imei: " + imei);
        }
        for (int i = 0; i < imei.length(); ++i) {
            char c = imei.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("not a valid imei: " + imei);
        }
        if (IMEICondition.imei == null) {
            System.err.println("The OSGi Reference Implementation of org.osgi.util.gsm.IMEICondition ");
            System.err.println("needs the system property org.osgi.util.gsm.imei set.");
            return Condition.FALSE;
        }
        return IMEICondition.imei.startsWith(imei) ? Condition.TRUE : Condition.FALSE;
    }
}

