/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.camel.util.BasicSerializationHeaderFilterStrategy;
import org.apache.servicemix.camel.util.HeaderFilterStrategies;
import org.apache.servicemix.camel.util.NoCheckSerializationHeaderFilterStrategy;
import org.apache.servicemix.camel.util.StrictSerializationHeaderFilterStrategy;
import org.apache.servicemix.jbi.exception.FaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiBinding {
    public static final String MESSAGE_EXCHANGE = "JbiMessageExchange";
    public static final String OPERATION = "JbiOperation";
    public static final String SECURITY_SUBJECT = "JbiSecuritySubject";
    private static final Log LOG = LogFactory.getLog(JbiBinding.class);
    private final CamelContext context;
    private HeaderFilterStrategies strategies = new HeaderFilterStrategies();
    private boolean convertExceptions;

    public JbiBinding(CamelContext context) {
        this(context, "basic");
    }

    public JbiBinding(CamelContext context, String serialization) {
        this.context = context;
        if (serialization == null) {
            this.strategies.add(new BasicSerializationHeaderFilterStrategy());
        } else if (serialization.equalsIgnoreCase("strict")) {
            this.strategies.add(new StrictSerializationHeaderFilterStrategy());
        } else if (serialization.equalsIgnoreCase("nocheck")) {
            this.strategies.add(new NoCheckSerializationHeaderFilterStrategy());
        } else {
            this.strategies.add(new BasicSerializationHeaderFilterStrategy());
        }
    }

    public void addHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.strategies.add(strategy);
    }

    public void setConvertExceptions(boolean convertExceptions) {
        this.convertExceptions = convertExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithCamelContextClassLoader(Callable<T> callable) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader loader = this.context.getApplicationContextClassLoader();
            if (loader != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Set the thread context classloader " + loader));
                }
                Thread.currentThread().setContextClassLoader(loader);
            }
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public MessageExchange makeJbiMessageExchange(Exchange camelExchange, MessageExchangeFactory exchangeFactory, String defaultMep) throws MessagingException, URISyntaxException {
        MessageExchange jbiExchange = this.createJbiMessageExchange(camelExchange, exchangeFactory, defaultMep);
        this.copyPropertiesFromCamelToJbi(camelExchange, jbiExchange);
        NormalizedMessage normalizedMessage = jbiExchange.getMessage("in");
        if (normalizedMessage == null) {
            normalizedMessage = jbiExchange.createMessage();
            jbiExchange.setMessage(normalizedMessage, "in");
        }
        this.copyFromCamelToJbi(camelExchange.getIn(), normalizedMessage);
        return jbiExchange;
    }

    protected MessageExchange createJbiMessageExchange(Exchange camelExchange, MessageExchangeFactory exchangeFactory, String defaultMep) throws MessagingException, URISyntaxException {
        ExchangePattern mep = ExchangePattern.fromWsdlUri((String)defaultMep);
        if (mep == null) {
            mep = camelExchange.getPattern();
        }
        Object answer = null;
        if (mep != null) {
            answer = mep == ExchangePattern.InOnly ? exchangeFactory.createInOnlyExchange() : (mep == ExchangePattern.InOptionalOut ? exchangeFactory.createInOptionalOutExchange() : (mep == ExchangePattern.InOut ? exchangeFactory.createInOutExchange() : (mep == ExchangePattern.RobustInOnly ? exchangeFactory.createRobustInOnlyExchange() : exchangeFactory.createExchange(new URI(mep.toString())))));
        }
        if (JbiBinding.getOperation(camelExchange) != null) {
            answer.setOperation(JbiBinding.getOperation(camelExchange));
        }
        return answer;
    }

    public Exchange createExchange(MessageExchange exchange) {
        DefaultExchange result = new DefaultExchange(this.context);
        result.setProperty(MESSAGE_EXCHANGE, (Object)exchange);
        result.setPattern(this.getExchangePattern(exchange));
        if (exchange.getOperation() != null) {
            result.setProperty(OPERATION, (Object)exchange.getOperation());
        }
        if (exchange.getMessage("in") != null) {
            this.copyFromJbiToCamel(exchange.getMessage("in"), result.getIn());
        }
        this.copyPropertiesFromJbiToCamel(exchange, (Exchange)result);
        return result;
    }

    private ExchangePattern getExchangePattern(MessageExchange exchange) {
        if (exchange instanceof InOut) {
            return ExchangePattern.InOut;
        }
        if (exchange instanceof InOptionalOut) {
            return ExchangePattern.InOptionalOut;
        }
        if (exchange instanceof RobustInOnly) {
            return ExchangePattern.RobustInOnly;
        }
        return ExchangePattern.InOnly;
    }

    public void copyPropertiesFromJbiToCamel(MessageExchange from, Exchange to) {
        for (Object object : from.getPropertyNames()) {
            String key = object.toString();
            if (this.strategies.applyFilterToCamelHeaders(key, from.getProperty(key), null)) continue;
            to.setProperty(key, from.getProperty(key));
        }
    }

    public void copyFromJbiToCamel(NormalizedMessage from, Message to) {
        to.setBody((Object)from.getContent());
        if (from.getSecuritySubject() != null) {
            to.setHeader(SECURITY_SUBJECT, (Object)from.getSecuritySubject());
        }
        for (Object object : from.getPropertyNames()) {
            String key = object.toString();
            if (this.strategies.applyFilterToCamelHeaders(key, from.getProperty(key), to.getExchange())) continue;
            to.setHeader(key, from.getProperty(key));
        }
        for (Object id : from.getAttachmentNames()) {
            to.addAttachment(id.toString(), from.getAttachment(id.toString()));
        }
    }

    public void copyFromCamelToJbi(Message message, NormalizedMessage normalizedMessage) throws MessagingException {
        if (message != null && message.getBody() != null) {
            if (message.getBody(Source.class) == null) {
                LOG.warn((Object)("Unable to convert message body of type " + message.getBody().getClass() + " into an XML Source"));
            } else {
                normalizedMessage.setContent((Source)message.getBody(Source.class));
            }
        }
        if (JbiBinding.getSecuritySubject(message) != null) {
            normalizedMessage.setSecuritySubject(JbiBinding.getSecuritySubject(message));
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || this.strategies.applyFilterToCamelHeaders(key, value, message.getExchange())) continue;
            normalizedMessage.setProperty(key, value);
        }
        for (String id : message.getAttachmentNames()) {
            normalizedMessage.addAttachment(id, message.getAttachment(id));
        }
    }

    public void copyFromCamelToJbi(Exchange exchange, MessageExchange messageExchange) throws MessagingException {
        this.copyPropertiesFromCamelToJbi(exchange, messageExchange);
        NormalizedMessage in = messageExchange.getMessage("in");
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            in.setProperty((String)entry.getKey(), entry.getValue());
        }
        if (this.isOutCapable(messageExchange)) {
            NormalizedMessage out;
            if (exchange.hasOut()) {
                out = messageExchange.createMessage();
                this.copyFromCamelToJbi(exchange.getOut(), out);
                messageExchange.setMessage(out, "out");
            } else {
                out = messageExchange.createMessage();
                this.copyFromCamelToJbi(exchange.getIn(), out);
                messageExchange.setMessage(out, "out");
            }
        }
    }

    public Exception extractException(Exchange exchange) {
        Exception e = exchange.getException();
        if (e == null || this.convertExceptions) {
            e = (Exception)this.context.getTypeConverter().convertTo(FaultException.class, (Object)exchange);
        }
        return e;
    }

    private void copyPropertiesFromCamelToJbi(Exchange exchange, MessageExchange messageExchange) {
        for (String key : exchange.getProperties().keySet()) {
            if (messageExchange.getProperty(key) != null) continue;
            Object value = exchange.getProperty(key);
            if (MESSAGE_EXCHANGE.equals(key) || value == null || this.strategies.applyFilterToCamelHeaders(key, value, exchange)) continue;
            messageExchange.setProperty(key, value);
        }
    }

    private boolean isOutCapable(MessageExchange exchange) {
        return exchange instanceof InOut || exchange instanceof InOptionalOut;
    }

    public static MessageExchange getMessageExchange(Exchange exchange) {
        return (MessageExchange)exchange.getProperty(MESSAGE_EXCHANGE, MessageExchange.class);
    }

    public static QName getOperation(Exchange exchange) {
        return (QName)exchange.getProperty(OPERATION, QName.class);
    }

    public static Subject getSecuritySubject(Message message) {
        if (message.getHeader(SECURITY_SUBJECT) != null) {
            return (Subject)message.getHeader(SECURITY_SUBJECT, Subject.class);
        }
        return null;
    }
}

