/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.osgi;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.camel.CamelJbiComponent;
import org.apache.servicemix.camel.CamelSpringDeployer;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.xbean.ClassLoaderXmlPreprocessor;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

public class OsgiCamelJbiComponent
extends CamelJbiComponent {
    private static final Log LOG = LogFactory.getLog(OsgiCamelJbiComponent.class);
    private BundleContext bundleContext;
    private long shutdownTimeout;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public BaseServiceUnitManager createServiceUnitManager() {
        OsgiCamelSpringDeployer deployer = new OsgiCamelSpringDeployer(this);
        return new BaseServiceUnitManager((ServiceMixComponent)this, new Deployer[]{deployer});
    }

    public void prepareShutdown(Endpoint endpoint) throws InterruptedException {
        this.prepareShutdown(endpoint, this.shutdownTimeout);
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public class OsgiClassLoaderXmlPreprocessor
    extends ClassLoaderXmlPreprocessor {
        public OsgiClassLoaderXmlPreprocessor(File root, ServiceMixComponent component) {
            super(root, component);
        }

        protected ClassLoader getParentClassLoader(SpringApplicationContext applicationContext) {
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            parents.add(super.getParentClassLoader(applicationContext));
            for (Bundle bundle : OsgiCamelJbiComponent.this.bundleContext.getBundles()) {
                try {
                    String symbolicName = bundle.getSymbolicName();
                    if (!symbolicName.contains("camel-spring") && !symbolicName.contains("camel-osgi") && !symbolicName.contains("camel-cxf")) continue;
                    parents.add((ClassLoader)BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle));
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            return new JarFileClassLoader("SU parent class loader", new URL[0], parents.toArray(new ClassLoader[parents.size()]));
        }
    }

    private class OsgiBundleContextPostprocessor
    implements BeanFactoryPostProcessor {
        private OsgiBundleContextPostprocessor() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    if (bean instanceof BundleContextAware) {
                        BundleContextAware bundleContextAware = (BundleContextAware)bean;
                        if (OsgiCamelJbiComponent.this.bundleContext == null) {
                            LOG.warn((Object)("No bundle defined yet so cannot inject into: " + bean));
                        } else {
                            bundleContextAware.setBundleContext(OsgiCamelJbiComponent.this.bundleContext);
                        }
                    }
                    return bean;
                }
            });
        }
    }

    public class OsgiCamelSpringDeployer
    extends CamelSpringDeployer {
        public OsgiCamelSpringDeployer(OsgiCamelJbiComponent component) {
            super(component);
        }

        protected List getXmlPreProcessors(String serviceUnitRootPath) {
            OsgiClassLoaderXmlPreprocessor classLoaderXmlPreprocessor = new OsgiClassLoaderXmlPreprocessor(new File(serviceUnitRootPath), OsgiCamelJbiComponent.this.component);
            return Collections.singletonList(classLoaderXmlPreprocessor);
        }

        protected List getBeanFactoryPostProcessors(String serviceUnitRootPath) {
            List processors = super.getBeanFactoryPostProcessors(serviceUnitRootPath);
            processors.add(new OsgiBundleContextPostprocessor());
            return processors;
        }
    }
}

