/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.osgi;

import org.apache.servicemix.camel.CamelComponent;
import org.apache.servicemix.camel.JbiComponent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class OsgiJbiComponent
extends JbiComponent
implements InitializingBean,
DisposableBean {
    private BundleContext bundleContext;
    private ServiceReference reference;

    public void afterPropertiesSet() throws Exception {
        this.bundleContext = FrameworkUtil.getBundle(OsgiJbiComponent.class).getBundleContext();
        this.reference = this.bundleContext.getServiceReference(CamelComponent.class.getName());
        if (this.reference == null) {
            throw new IllegalStateException(CamelComponent.class.getName() + " not found in the OSGi registry");
        }
        CamelComponent component = (CamelComponent)this.bundleContext.getService(this.reference);
        this.setCamelJbiComponent(component);
    }

    public void destroy() throws Exception {
        if (this.reference != null) {
            this.bundleContext.ungetService(this.reference);
        }
    }
}

