/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.war;

import java.io.File;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;

public class WarDeploymentListener
implements ArtifactUrlTransformer {
    private static final String PATH_SEPERATOR = "/";

    public boolean canHandle(File artifact) {
        try {
            JarFile jar = new JarFile(artifact);
            JarEntry entry = jar.getJarEntry("WEB-INF/web.xml");
            if (entry == null) {
                return false;
            }
            Manifest m = jar.getManifest();
            return m == null || m.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) == null || m.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public URL transform(URL artifact) throws Exception {
        String path = artifact.getPath();
        String protocol = artifact.getProtocol();
        int lastSlash = 0;
        if ("jardir".equalsIgnoreCase(protocol)) {
            File fileInstance = new File(path);
            lastSlash = fileInstance.getAbsolutePath().lastIndexOf(File.separator);
        } else {
            lastSlash = path.lastIndexOf(PATH_SEPERATOR);
        }
        int suffixPos = path.length() - 4;
        String displayName = path.substring(lastSlash + 1, suffixPos);
        return new URL("war", null, protocol + ":" + path + "?Webapp-Context=" + displayName);
    }
}

