/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageScanRouteBuilderFinder {
    private static final transient Log LOG = LogFactory.getLog(PackageScanRouteBuilderFinder.class);
    private final BlueprintCamelContext camelContext;
    private final String[] packages;
    private final PackageScanClassResolver resolver;
    private final BlueprintContainer blueprintContainer;

    public PackageScanRouteBuilderFinder(BlueprintCamelContext camelContext, String[] packages, ClassLoader classLoader, PackageScanClassResolver resolver) {
        this.camelContext = camelContext;
        this.blueprintContainer = camelContext.getBlueprintContainer();
        this.packages = packages;
        this.resolver = resolver;
        resolver.addClassLoader(classLoader);
    }

    public void appendBuilders(List<RoutesBuilder> list) throws IllegalAccessException, InstantiationException {
        Set classes = this.resolver.findImplementations(RoutesBuilder.class, this.packages);
        for (Class aClass : classes) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found RouteBuilder class: " + aClass));
            }
            if (this.shouldIgnoreBean(aClass)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring RouteBuilder class: " + aClass));
                continue;
            }
            if (!this.isValidClass(aClass)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring invalid RouteBuilder class: " + aClass));
                continue;
            }
            RoutesBuilder builder = this.instantiateBuilder(aClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding instantiated RouteBuilder: " + builder));
            }
            list.add(builder);
        }
    }

    protected boolean shouldIgnoreBean(Class<?> type) {
        for (BeanMetadata metadata : this.blueprintContainer.getMetadata(BeanMetadata.class)) {
            Object bean;
            if (!"singleton".equals(metadata.getScope()) || !type.isInstance(bean = this.blueprintContainer.getComponentInstance(metadata.getId()))) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidClass(Class type) {
        return !Modifier.isAbstract(type.getModifiers()) && !type.isInterface();
    }

    protected RoutesBuilder instantiateBuilder(Class type) throws IllegalAccessException, InstantiationException {
        return (RoutesBuilder)this.camelContext.getInjector().newInstance(type);
    }
}

