/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfbc.interceptors;

import java.net.URI;
import java.util.HashMap;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.servicemix.cxfbc.WSAUtils;
import org.apache.servicemix.cxfbc.interceptors.CxfJbiConstants;
import org.apache.servicemix.soap.util.QNameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String OPERATION_MEP = "MEP";

    public JbiInInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) {
        try {
            NormalizedMessage nm;
            if (!this.isRequestor(message)) {
                MessageExchange exchange = this.createExchange(message);
                nm = exchange.createMessage();
                exchange.setMessage(nm, "in");
                message.setContent(MessageExchange.class, (Object)exchange);
            } else {
                MessageExchange exchange = (MessageExchange)message.getContent(MessageExchange.class);
                if (exchange == null) {
                    throw new IllegalStateException("Content of type " + MessageExchange.class + " not found on message");
                }
                if (message.getContent(Exception.class) == null) {
                    nm = exchange.createMessage();
                    exchange.setMessage(nm, "out");
                } else {
                    exchange.setFault(exchange.createFault());
                    nm = exchange.getFault();
                }
            }
            this.toNMSHeaders(nm, message);
            this.toNMSWSAHeaders(nm, message);
            this.toNMSAttachments(nm, message);
            nm.setSecuritySubject((Subject)message.get(Subject.class));
            this.getContent(nm, message);
            message.setContent(NormalizedMessage.class, (Object)nm);
        }
        catch (JBIException e) {
            throw new Fault((Throwable)e);
        }
    }

    private MessageExchange createExchange(Message message) throws JBIException {
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        URI mep = operation != null ? (operation.getOutput() == null ? CxfJbiConstants.IN_ONLY : CxfJbiConstants.IN_OUT) : (URI)message.get((Object)OPERATION_MEP);
        if (mep == null) {
            throw new NullPointerException("MEP not found");
        }
        MessageExchangeFactory mef = (MessageExchangeFactory)message.getExchange().get(MessageExchangeFactory.class);
        if (mef == null) {
            DeliveryChannel dv = (DeliveryChannel)message.getExchange().get(DeliveryChannel.class);
            if (dv == null) {
                ComponentContext cc = (ComponentContext)message.getExchange().get(ComponentContext.class);
                if (cc == null) {
                    throw new NullPointerException("MessageExchangeFactory or DeliveryChannel or ComponentContext not found");
                }
                dv = cc.getDeliveryChannel();
            }
            mef = dv.createExchangeFactory();
        }
        MessageExchange me = mef.createExchange(mep);
        me.setOperation(operation.getName());
        return me;
    }

    private void toNMSWSAHeaders(NormalizedMessage normalizedMessage, Message soapMessage) {
        SoapMessage message = null;
        if (!(soapMessage instanceof SoapMessage)) {
            return;
        }
        message = (SoapMessage)soapMessage;
        if (message.get((Object)"javax.xml.ws.addressing.context.inbound") != null) {
            normalizedMessage.setProperty("javax.xml.ws.addressing.context.inbound", WSAUtils.getAsMap((AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.inbound")));
        }
    }

    private void toNMSHeaders(NormalizedMessage normalizedMessage, Message soapMessage) {
        SoapMessage message = null;
        if (!(soapMessage instanceof SoapMessage)) {
            return;
        }
        message = (SoapMessage)soapMessage;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        QName excludeName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        for (Header header : message.getHeaders()) {
            if (header.getName().equals(excludeName)) continue;
            headers.put(QNameUtil.toString((QName)header.getName()), header.getObject());
        }
        normalizedMessage.setProperty("javax.jbi.messaging.protocol.headers", headers);
    }

    private void toNMSAttachments(NormalizedMessage normalizedMessage, Message soapMessage) throws MessagingException {
        if (soapMessage.getAttachments() != null) {
            for (Attachment att : soapMessage.getAttachments()) {
                normalizedMessage.addAttachment(att.getId(), att.getDataHandler());
            }
        }
    }

    private void getContent(NormalizedMessage nm, Message message) throws MessagingException {
        Exception e = (Exception)message.getContent(Exception.class);
        if (e == null) {
            nm.setContent((Source)message.getContent(Source.class));
        }
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }
}

