/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;

public class Address
implements DestinationAddress {
    private TypeOfNumber typeOfNumber;
    private NumberingPlanIndicator numberingPlanIndicator;
    private String address;

    public Address(TypeOfNumber typeOfNumber, NumberingPlanIndicator numberingPlanIndicator, String address) {
        this.typeOfNumber = typeOfNumber;
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.address = address;
    }

    public Address(byte typeOfNumber, byte numberingPlanIndicator, String address) {
        this(TypeOfNumber.valueOf(typeOfNumber), NumberingPlanIndicator.valueOf(numberingPlanIndicator), address);
    }

    public DestinationAddress.Flag getFlag() {
        return DestinationAddress.Flag.SME_ADDRESS;
    }

    public TypeOfNumber getTypeOfNumber() {
        return this.typeOfNumber;
    }

    public byte getTon() {
        return this.typeOfNumber.value();
    }

    public NumberingPlanIndicator getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public byte getNpi() {
        return this.numberingPlanIndicator.value();
    }

    public String getAddress() {
        return this.address;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.numberingPlanIndicator == null ? 0 : this.numberingPlanIndicator.hashCode());
        result = 31 * result + (this.typeOfNumber == null ? 0 : this.typeOfNumber.hashCode());
        return result;
    }

    private boolean hasEqualAddress(Address other) {
        if (this.address == null && other.address != null) {
            return false;
        }
        return this.address.equals(other.address);
    }

    private boolean hasEqualNumberingPlanIndicator(Address other) {
        if (this.numberingPlanIndicator == null && other.numberingPlanIndicator != null) {
            return false;
        }
        return this.numberingPlanIndicator.equals((Object)other.numberingPlanIndicator);
    }

    private boolean hasEqualTypeOfNumber(Address other) {
        if (this.typeOfNumber == null && other.typeOfNumber != null) {
            return false;
        }
        return this.typeOfNumber.equals((Object)other.typeOfNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (!this.hasEqualAddress(other)) {
            return false;
        }
        if (!this.hasEqualNumberingPlanIndicator(other)) {
            return false;
        }
        return this.hasEqualTypeOfNumber(other);
    }
}

