/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;
import org.jsmpp.util.OctetUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OptionalParameterTest {
    @Test(groups={"checkintest"})
    public void stringParameterSerialization() {
        OptionalParameter.OctetString param = new OptionalParameter.OctetString(OptionalParameter.Tag.DEST_SUBADDRESS, "jeah");
        byte[] serialised = param.serialize();
        Assert.assertEquals((int)serialised.length, (int)8);
        Assert.assertEquals((short)OctetUtil.bytesToShort(serialised, 0), (short)OptionalParameter.Tag.DEST_SUBADDRESS.code());
        Assert.assertEquals((int)OctetUtil.bytesToShort(serialised, 2), (int)"jeah".getBytes().length);
        Assert.assertEquals((String)new String(serialised, 4, serialised.length - 4), (String)"jeah");
    }

    @Test(groups={"checkintest"})
    public void stringParameterDeserialization() {
        OptionalParameter param = OptionalParameters.deserialize(OptionalParameter.Tag.DEST_SUBADDRESS.code(), "jeah".getBytes());
        Assert.assertTrue((boolean)(param instanceof OptionalParameter.OctetString));
        OptionalParameter.OctetString stringParam = (OptionalParameter.OctetString)param;
        Assert.assertEquals((String)stringParam.getValueAsString(), (String)"jeah");
    }

    @Test
    public void undefinedTag() {
        boolean tagCode = false;
        try {
            OptionalParameter.Tag.valueOf((short)0);
            Assert.fail((String)"Tag code 0x0000 should be not found");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        OptionalParameters.deserialize((short)0, "Undefined tag".getBytes());
    }

    @Test
    public void anotherUndefinedTag() {
        short tagCode = -127;
        try {
            OptionalParameter.Tag.valueOf(tagCode);
            Assert.fail((String)("Tag code " + tagCode + " should be not found"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        OptionalParameters.deserialize(tagCode, "Undefined tag".getBytes());
    }
}

