/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.BasicConfigurator;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.SMPPServerSessionListener;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;

public class ReceiveSubmittedMessageExample {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            final RandomMessageIDGenerator messageIdGenerator = new RandomMessageIDGenerator();
            ServerMessageReceiverListener messageReceiverListener = new ServerMessageReceiverListener(){

                public MessageId onAcceptSubmitSm(SubmitSm submitSm, SMPPServerSession source) throws ProcessRequestException {
                    System.out.println("Receiving message : " + new String(submitSm.getShortMessage()));
                    return messageIdGenerator.newMessageId();
                }

                public QuerySmResult onAcceptQuerySm(QuerySm querySm, SMPPServerSession source) throws ProcessRequestException {
                    return null;
                }

                public SubmitMultiResult onAcceptSubmitMulti(SubmitMulti submitMulti, SMPPServerSession source) throws ProcessRequestException {
                    return null;
                }

                public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
                    return null;
                }

                public void onAcceptCancelSm(CancelSm cancelSm, SMPPServerSession source) throws ProcessRequestException {
                }

                public void onAcceptReplaceSm(ReplaceSm replaceSm, SMPPServerSession source) throws ProcessRequestException {
                }
            };
            System.out.println("Listening ...");
            SMPPServerSessionListener sessionListener = new SMPPServerSessionListener(8056);
            sessionListener.setMessageReceiverListener(messageReceiverListener);
            SMPPServerSession session = sessionListener.accept();
            System.out.println("Accept connection");
            try {
                BindRequest request = session.waitForBind(5000L);
                System.out.println("Receive bind request");
                if (request.getBindParameter().getSystemId().equals("test") && request.getBindParameter().getPassword().equals("test")) {
                    System.out.println("Accepting bind request");
                    request.accept("sys");
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    System.out.println("Rejecting bind request");
                    request.reject(14);
                }
            }
            catch (TimeoutException e) {
                System.out.println("No binding request made after 5000 millisecond");
                e.printStackTrace();
            }
            System.out.println("Closing session");
            session.unbindAndClose();
            System.out.println("Closing session listener");
            sessionListener.close();
        }
        catch (PDUStringException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

