/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindType;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.DummyResponseHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BindRequestTest {
    private DummyResponseHandler responseHandler;
    private BindRequest bindRequest;

    @BeforeMethod
    public void setUp() {
        this.responseHandler = new DummyResponseHandler();
        this.bindRequest = new BindRequest(1, BindType.BIND_TRX, null, null, null, null, null, null, this.responseHandler);
    }

    @Test(groups={"checkintest"})
    public void testSucceedAccept() {
        try {
            this.bindRequest.accept("sys");
        }
        catch (PDUStringException e) {
            Assert.fail((String)"Should succes accepting bind request");
        }
        catch (IllegalStateException e1) {
            Assert.fail((String)"Should succes accepting bind request");
        }
        catch (IOException e1) {
            Assert.fail((String)"Should succes accepting bind request");
        }
    }

    @Test(groups={"checkintest"})
    public void testFailedAccept() {
        this.responseHandler.closeConnection();
        try {
            this.bindRequest.accept("sys");
            Assert.fail((String)"Should throw IOException");
        }
        catch (PDUStringException e) {
            Assert.fail((String)"Should throw IOException");
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(groups={"checkintest"})
    public void testSucceedReject() {
        try {
            this.bindRequest.reject(-1);
        }
        catch (IllegalStateException e1) {
            Assert.fail((String)"Should succes rejecting bind request");
        }
        catch (IOException e1) {
            Assert.fail((String)"Should succes rejecting bind request");
        }
    }

    @Test(groups={"checkintest"})
    public void testFailedReject() {
        this.responseHandler.closeConnection();
        try {
            this.bindRequest.reject(-1);
            Assert.fail((String)"Should throw IOException");
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(groups={"checkintest"})
    public void testNonSingleAccept() {
        try {
            this.bindRequest.accept("sys");
        }
        catch (PDUStringException e) {
            Assert.fail((String)"Should success accepting bind request");
        }
        catch (IllegalStateException e1) {
            Assert.fail((String)"Should success accepting bind request");
        }
        catch (IOException e1) {
            Assert.fail((String)"Should success accepting bind request");
        }
        try {
            this.bindRequest.accept("sys");
            Assert.fail((String)"Should fail on 2nd accept");
        }
        catch (PDUStringException e) {
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (IOException e) {
            Assert.fail((String)"Should throw IllegalStateException");
        }
    }

    @Test(groups={"checkintest"})
    public void testNonSingleReject() {
        try {
            this.bindRequest.reject(-1);
        }
        catch (IllegalStateException e1) {
            Assert.fail((String)"Should success rejecting bind request");
        }
        catch (IOException e1) {
            Assert.fail((String)"Should success rejecting bind request");
        }
        try {
            this.bindRequest.reject(-1);
            Assert.fail((String)"Should fail on 2nd reject");
        }
        catch (IllegalStateException e1) {
        }
        catch (IOException e) {
            Assert.fail((String)"Should throw IllegalStateException");
        }
    }
}

