/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.util.Arrays;

public class HexUtil {
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String convertStringToHexString(String data) {
        return HexUtil.conventBytesToHexString(data.getBytes());
    }

    public static String conventBytesToHexString(byte[] data) {
        return HexUtil.convertBytesToHexString(data, 0, data.length);
    }

    public static String convertBytesToHexString(byte[] data, int offset, int length) {
        StringBuffer sBuf = new StringBuffer();
        int i = offset;
        while (i < length) {
            sBuf.append(hexChar[data[i] >> 4 & 0xF]);
            sBuf.append(hexChar[data[i] & 0xF]);
            ++i;
        }
        return sBuf.toString();
    }

    public static String convertHexStringToString(String hexString) {
        String uHexString = hexString.toLowerCase();
        StringBuffer sBuf = new StringBuffer();
        int i = 0;
        while (i < uHexString.length()) {
            char c = (char)Integer.parseInt(uHexString.substring(i, i + 2), 16);
            sBuf.append(c);
            i += 2;
        }
        return sBuf.toString();
    }

    public static byte[] convertHexStringToBytes(String hexString) {
        return HexUtil.convertHexStringToBytes(hexString, 0, hexString.length());
    }

    public static byte[] convertHexStringToBytes(String hexString, int offset, int endIndex) {
        String realHexString = hexString.substring(offset, endIndex).toLowerCase();
        byte[] data = realHexString.length() % 2 == 0 ? new byte[realHexString.length() / 2] : new byte[(int)Math.ceil((double)realHexString.length() / 2.0)];
        int j = 0;
        int i = 0;
        while (i < realHexString.length()) {
            char[] tmp;
            try {
                tmp = realHexString.substring(i, i + 2).toCharArray();
            }
            catch (StringIndexOutOfBoundsException siob) {
                tmp = (String.valueOf(realHexString.substring(i)) + "0").toCharArray();
            }
            data[j] = (byte)((Arrays.binarySearch(hexChar, tmp[0]) & 0xF) << 4);
            int n = j++;
            data[n] = (byte)(data[n] | (byte)(Arrays.binarySearch(hexChar, tmp[1]) & 0xF));
            i += 2;
        }
        i = realHexString.length();
        while (i > 0) {
            i -= 2;
        }
        return data;
    }
}

