/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

public class OctetUtil {
    public static byte[] intToBytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static byte[] shortToBytes(short value) {
        byte[] result = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static int bytesToInt(byte[] bytes) {
        return OctetUtil.bytesToInt(bytes, 0);
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        int result = 0;
        int length = 0;
        length = bytes.length - offset < 4 ? bytes.length - offset : 4;
        int end = offset + length;
        int i = 0;
        while (i < length) {
            result |= (bytes[end - i - 1] & 0xFF) << 8 * i;
            ++i;
        }
        return result;
    }

    public static short bytesToShort(byte[] bytes) {
        return OctetUtil.bytesToShort(bytes, 0);
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        short result = 0;
        int end = offset + 2;
        int i = 0;
        while (i < 2) {
            result = (short)(result | (bytes[end - i - 1] & 0xFF) << 8 * i);
            ++i;
        }
        return result;
    }
}

