/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.TextMessage;
import org.apache.activemq.broker.util.CommandHandler;
import org.apache.activemq.console.CommandContext;
import org.apache.activemq.console.command.ShellCommand;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleCommandHandler
implements CommandHandler {
    private ShellCommand command = new ShellCommand(true);

    public void processCommand(TextMessage request, TextMessage response) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CommandContext ctx = new CommandContext();
        ctx.setFormatter(new CommandShellOutputFormatter(out));
        String requestText = request.getText();
        List<String> tokens = this.tokenize(requestText);
        this.command.setCommandContext(ctx);
        this.command.execute(tokens);
        out.flush();
        byte[] bytes = out.toByteArray();
        String answer = new String(bytes);
        response.setText(answer);
    }

    protected List<String> tokenize(String text) {
        ArrayList<String> answer = new ArrayList<String>();
        StringTokenizer iter = new StringTokenizer(text);
        while (iter.hasMoreTokens()) {
            answer.add(iter.nextToken());
        }
        return answer;
    }
}

