/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package loanbroker;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;

/**
 * A Camel Router
 *
 * @version $Revision: 1.1 $
 */
public class CreditAgencyRouteBuilder extends RouteBuilder {
    
    public void configure() {
	from("jbi:endpoint:urn:logicblaze:soa:creditagency:CreditAgencyService:agency").to("log:org.apache.servicemix.examples?level=DEBUG")
	    .choice()
	    .when(header("JbiOperation").isEqualTo("{urn:logicblaze:soa:creditagency}getCreditHistoryLength"))
	    .transform(constant("<getCreditHistoryLengthResponse xmlns='urn:logicblaze:soa:creditagency'><length>" + 100 + "</length></getCreditHistoryLengthResponse>"))
	    
	    .when(header("JbiOperation").isEqualTo("{urn:logicblaze:soa:creditagency}getCreditScore"))
	    .transform(constant("<getCreditScoreResponse xmlns='urn:logicblaze:soa:creditagency'><score>" + 1000 + "</score></getCreditScoreResponse>"))
	    
	    .otherwise().setFaultBody(constant("<UnknownOperation xmlns='urn:logicblaze:soa:creditagency'/>"));
    }
}
