/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.extender;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.extender.BundleScanner;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleEntryScanner<T>
implements BundleScanner<T> {
    private final String m_path;
    private String m_filePattern;
    private final boolean m_recurse;

    public BundleEntryScanner(String path, String filePattern, boolean recurse) {
        NullArgumentException.validateNotNull("Path", path);
        NullArgumentException.validateNotNull("File pattern", filePattern);
        this.m_path = path;
        this.m_filePattern = filePattern;
        this.m_recurse = recurse;
    }

    @Override
    public List<T> scan(Bundle bundle) {
        ArrayList<T> resources = new ArrayList<T>();
        Enumeration e = bundle.findEntries(this.m_path, this.m_filePattern, this.m_recurse);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL entry = (URL)e.nextElement();
                if (entry == null) continue;
                resources.add(this.createResource(bundle, entry));
            }
        }
        return resources;
    }

    protected abstract T createResource(Bundle var1, URL var2);

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("path=").append(this.m_path).append(",filePattern=").append(this.m_filePattern).append(",recurse=").append(this.m_recurse).append("}").toString();
    }
}

