/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.WebAppHttpContext;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;

class RegisterWebAppVisitorWC
implements WebAppVisitor {
    private static final Log LOG = LogFactory.getLog(RegisterWebAppVisitorWC.class);
    private final WebContainer m_webContainer;
    private HttpContext m_httpContext;
    private ClassLoader m_bundleClassLoader;

    RegisterWebAppVisitorWC(WebContainer webContainer) {
        NullArgumentException.validateNotNull(webContainer, "Web container");
        this.m_webContainer = webContainer;
    }

    public void visit(WebApp webApp) {
        NullArgumentException.validateNotNull(webApp, "Web app");
        this.m_bundleClassLoader = new BundleClassLoader(webApp.getBundle());
        this.m_httpContext = new WebAppHttpContext(this.m_webContainer.createDefaultHttpContext(), webApp.getBundle(), webApp.getMimeMappings());
        webApp.setHttpContext(this.m_httpContext);
        try {
            this.m_webContainer.setContextParam(RegisterWebAppVisitorHS.convertInitParams(webApp.getContextParams()), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
        try {
            this.m_webContainer.registerResources("/", "", this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
        try {
            String[] welcomeFiles = webApp.getWelcomeFiles();
            if (welcomeFiles != null && welcomeFiles.length > 0) {
                this.m_webContainer.registerWelcomeFiles(welcomeFiles, true, this.m_httpContext);
            }
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
        try {
            this.m_webContainer.registerJsps(new String[]{"*.jsp"}, this.m_httpContext);
        }
        catch (UnsupportedOperationException ignore) {
            LOG.warn(ignore.getMessage());
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull(webAppServlet, "Web app servlet");
        String[] urlPatterns = webAppServlet.getAliases();
        if (urlPatterns == null || urlPatterns.length == 0) {
            LOG.warn("Servlet [" + webAppServlet + "] does not have any mapping. Skipped.");
        }
        try {
            Servlet servlet = RegisterWebAppVisitorHS.newInstance(Servlet.class, this.m_bundleClassLoader, webAppServlet.getServletClass());
            webAppServlet.setServlet(servlet);
            this.m_webContainer.registerServlet(servlet, urlPatterns, RegisterWebAppVisitorHS.convertInitParams(webAppServlet.getInitParams()), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppFilter webAppFilter) {
        NullArgumentException.validateNotNull(webAppFilter, "Web app filter");
        String[] urlPatterns = webAppFilter.getUrlPatterns();
        String[] servletNames = webAppFilter.getServletNames();
        if (!(urlPatterns != null && urlPatterns.length != 0 || servletNames != null && servletNames.length != 0)) {
            LOG.warn("Filter [" + webAppFilter + "] does not have any mapping. Skipped.");
        }
        try {
            Filter filter = RegisterWebAppVisitorHS.newInstance(Filter.class, this.m_bundleClassLoader, webAppFilter.getFilterClass());
            webAppFilter.setFilter(filter);
            this.m_webContainer.registerFilter(filter, urlPatterns, servletNames, RegisterWebAppVisitorHS.convertInitParams(webAppFilter.getInitParams()), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppListener webAppListener) {
        NullArgumentException.validateNotNull(webAppListener, "Web app listener");
        try {
            EventListener listener = RegisterWebAppVisitorHS.newInstance(EventListener.class, this.m_bundleClassLoader, webAppListener.getListenerClass());
            webAppListener.setListener(listener);
            this.m_webContainer.registerEventListener(listener, this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
    }

    public void visit(WebAppErrorPage webAppErrorPage) {
        NullArgumentException.validateNotNull(webAppErrorPage, "Web app error page");
        try {
            this.m_webContainer.registerErrorPage(webAppErrorPage.getError(), webAppErrorPage.getLocation(), this.m_httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
    }
}

