/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;

public class WebAppServlet {
    private String m_servletName;
    private String m_servletClass;
    private Servlet m_servlet;
    private final List<WebAppInitParam> m_initParams;
    private final Set<String> m_aliases = new HashSet<String>();

    public WebAppServlet() {
        this.m_initParams = new ArrayList<WebAppInitParam>();
    }

    public String getServletName() {
        return this.m_servletName;
    }

    public void setServletName(String servletName) {
        NullArgumentException.validateNotNull(servletName, "Servlet name");
        this.m_servletName = servletName;
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName("servlet-name");
        initParam.setParamValue(servletName);
        this.m_initParams.add(initParam);
    }

    public String getServletClass() {
        return this.m_servletClass;
    }

    public void setServletClass(String servletClass) {
        NullArgumentException.validateNotNull(servletClass, "Servlet class");
        this.m_servletClass = servletClass;
    }

    public Servlet getServlet() {
        return this.m_servlet;
    }

    public void setServlet(Servlet servlet) {
        this.m_servlet = servlet;
    }

    public String[] getAliases() {
        return this.m_aliases.toArray(new String[this.m_aliases.size()]);
    }

    public void addUrlPattern(String urlPattern) {
        NullArgumentException.validateNotNull(urlPattern, "Url pattern");
        this.m_aliases.add(urlPattern);
    }

    public void addInitParam(WebAppInitParam param) {
        NullArgumentException.validateNotNull(param, "Init param");
        NullArgumentException.validateNotNull(param.getParamName(), "Init param name");
        NullArgumentException.validateNotNull(param.getParamValue(), "Init param value");
        this.m_initParams.add(param);
    }

    public WebAppInitParam[] getInitParams() {
        return this.m_initParams.toArray(new WebAppInitParam[this.m_initParams.size()]);
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("servletName=").append(this.m_servletName).append(",servletClass=").append(this.m_servletClass).append(",aliases=").append(this.m_aliases).append("}").toString();
    }
}

