/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser.dom;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.war.internal.WebXmlParser;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.ops4j.util.xml.ElementHelper;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DOMWebXmlParser
implements WebXmlParser {
    private static final Log LOG = LogFactory.getLog(DOMWebXmlParser.class);

    public WebApp parse(InputStream inputStream) {
        WebApp webApp = null;
        try {
            Element rootElement = ElementHelper.getRootElement(inputStream);
            if (rootElement != null) {
                webApp = new WebApp();
                webApp.setDisplayName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(rootElement, "display-name")));
                DOMWebXmlParser.parseContextParams(rootElement, webApp);
                DOMWebXmlParser.parseServlets(rootElement, webApp);
                DOMWebXmlParser.parseFilters(rootElement, webApp);
                DOMWebXmlParser.parseListeners(rootElement, webApp);
                DOMWebXmlParser.parseErrorPages(rootElement, webApp);
                DOMWebXmlParser.parseWelcomeFiles(rootElement, webApp);
                DOMWebXmlParser.parseMimeMappings(rootElement, webApp);
            } else {
                LOG.warn("The parsed web.xml does not have a root element");
            }
        }
        catch (ParserConfigurationException ignore) {
            LOG.error("Cannot parse web.xml", ignore);
        }
        catch (IOException ignore) {
            LOG.error("Cannot parse web.xml", ignore);
        }
        catch (SAXException ignore) {
            LOG.error("Cannot parse web.xml", ignore);
        }
        return webApp;
    }

    private static void parseContextParams(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "context-param");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppInitParam initParam = new WebAppInitParam();
                initParam.setParamName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "param-name")));
                initParam.setParamValue(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "param-value")));
                webApp.addContextParam(initParam);
            }
        }
    }

    private static void parseServlets(Element rootElement, WebApp webApp) {
        Element[] mappingElements;
        Element[] elements = ElementHelper.getChildren(rootElement, "servlet");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppServlet servlet = new WebAppServlet();
                servlet.setServletName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "servlet-name")));
                servlet.setServletClass(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "servlet-class")));
                webApp.addServlet(servlet);
                Element[] initParamElements = ElementHelper.getChildren(element, "init-param");
                if (initParamElements == null || initParamElements.length <= 0) continue;
                for (Element initParamElement : initParamElements) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-name")));
                    initParam.setParamValue(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-value")));
                    servlet.addInitParam(initParam);
                }
            }
        }
        if ((mappingElements = ElementHelper.getChildren(rootElement, "servlet-mapping")) != null && mappingElements.length > 0) {
            for (Element mappingElement : mappingElements) {
                String servletName = DOMWebXmlParser.getTextContent(ElementHelper.getChild(mappingElement, "servlet-name"));
                Element[] urlPatternsElements = ElementHelper.getChildren(mappingElement, "url-pattern");
                if (urlPatternsElements == null || urlPatternsElements.length <= 0) continue;
                for (Element urlPatternElement : urlPatternsElements) {
                    WebAppServletMapping servletMapping = new WebAppServletMapping();
                    servletMapping.setServletName(servletName);
                    servletMapping.setUrlPattern(DOMWebXmlParser.getTextContent(urlPatternElement));
                    webApp.addServletMapping(servletMapping);
                }
            }
        }
    }

    private static void parseFilters(Element rootElement, WebApp webApp) {
        Element[] mappingElements;
        Element[] elements = ElementHelper.getChildren(rootElement, "filter");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppFilter filter = new WebAppFilter();
                filter.setFilterName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "filter-name")));
                filter.setFilterClass(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "filter-class")));
                webApp.addFilter(filter);
                Element[] initParamElements = ElementHelper.getChildren(element, "init-param");
                if (initParamElements == null || initParamElements.length <= 0) continue;
                for (Element initParamElement : initParamElements) {
                    WebAppInitParam initParam = new WebAppInitParam();
                    initParam.setParamName(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-name")));
                    initParam.setParamValue(DOMWebXmlParser.getTextContent(ElementHelper.getChild(initParamElement, "param-value")));
                    filter.addInitParam(initParam);
                }
            }
        }
        if ((mappingElements = ElementHelper.getChildren(rootElement, "filter-mapping")) != null && mappingElements.length > 0) {
            for (Element mappingElement : mappingElements) {
                Element[] servletNamesElements;
                String filterName = DOMWebXmlParser.getTextContent(ElementHelper.getChild(mappingElement, "filter-name"));
                Element[] urlPatternsElements = ElementHelper.getChildren(mappingElement, "url-pattern");
                if (urlPatternsElements != null && urlPatternsElements.length > 0) {
                    for (Element urlPatternElement : urlPatternsElements) {
                        WebAppFilterMapping servletMapping = new WebAppFilterMapping();
                        servletMapping.setFilterName(filterName);
                        servletMapping.setUrlPattern(DOMWebXmlParser.getTextContent(urlPatternElement));
                        webApp.addFilterMapping(servletMapping);
                    }
                }
                if ((servletNamesElements = ElementHelper.getChildren(mappingElement, "servlet-name")) == null || servletNamesElements.length <= 0) continue;
                for (Element servletNameElement : servletNamesElements) {
                    WebAppFilterMapping servletMapping = new WebAppFilterMapping();
                    servletMapping.setFilterName(filterName);
                    servletMapping.setServletName(DOMWebXmlParser.getTextContent(servletNameElement));
                    webApp.addFilterMapping(servletMapping);
                }
            }
        }
    }

    private static void parseListeners(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "listener");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppListener listener = new WebAppListener();
                listener.setListenerClass(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "listener-class")));
                webApp.addListener(listener);
            }
        }
    }

    private static void parseErrorPages(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "error-page");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppErrorPage errorPage = new WebAppErrorPage();
                errorPage.setErrorCode(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "error-code")));
                errorPage.setExceptionType(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "exception-type")));
                errorPage.setLocation(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "location")));
                webApp.addErrorPage(errorPage);
            }
        }
    }

    private static void parseWelcomeFiles(Element rootElement, WebApp webApp) {
        Element[] elements;
        Element listElement = ElementHelper.getChild(rootElement, "welcome-file-list");
        if (listElement != null && (elements = ElementHelper.getChildren(listElement, "welcome-file")) != null && elements.length > 0) {
            for (Element element : elements) {
                webApp.addWelcomeFile(DOMWebXmlParser.getTextContent(element));
            }
        }
    }

    private static void parseMimeMappings(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "mime-mapping");
        if (elements != null && elements.length > 0) {
            for (Element element : elements) {
                WebAppMimeMapping mimeMapping = new WebAppMimeMapping();
                mimeMapping.setExtension(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "extension")));
                mimeMapping.setMimeType(DOMWebXmlParser.getTextContent(ElementHelper.getChild(element, "mime-type")));
                webApp.addMimeMapping(mimeMapping);
            }
        }
    }

    private static String getTextContent(Element element) {
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }
}

