/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.gshell.features.internal.commands;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.servicemix.gshell.features.FeaturesService;
import org.apache.servicemix.gshell.features.Repository;
import org.apache.servicemix.gshell.features.internal.commands.FeaturesCommandSupport;

@CommandComponent(id="features:refreshUrl", description="Reload the repositories to obtain a fresh list of features")
public class RefreshUrlCommand
extends FeaturesCommandSupport {
    @Argument(required=false, multiValued=true, description="Repository URLs (leave empty for all)")
    List<String> urls;

    protected void doExecute(FeaturesService admin) throws Exception {
        if (this.urls == null || this.urls.isEmpty()) {
            this.urls = new ArrayList<String>();
            for (Repository repo : admin.listRepositories()) {
                this.urls.add(repo.getURL().toString());
            }
        }
        for (String strUrl : this.urls) {
            URL url = new URL(strUrl);
            admin.removeRepository(url);
            admin.addRepository(url);
        }
    }
}

