/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationResourceInfo {
    private URITemplate uriTemplate;
    private ClassResourceInfo classResourceInfo;
    private Method methodToInvoke;
    private Method annotatedMethod;
    private String httpMethod;
    private List<MediaType> produceMimes;
    private List<MediaType> consumeMimes;

    public OperationResourceInfo(Method m, ClassResourceInfo cri) {
        this.methodToInvoke = m;
        this.annotatedMethod = m;
        this.classResourceInfo = cri;
        this.checkMediaTypes();
    }

    public URITemplate getURITemplate() {
        return this.uriTemplate;
    }

    public void setURITemplate(URITemplate u) {
        this.uriTemplate = u;
    }

    public ClassResourceInfo getClassResourceInfo() {
        return this.classResourceInfo;
    }

    public void setClassResourceInfo(ClassResourceInfo c) {
        this.classResourceInfo = c;
    }

    public Method getMethodToInvoke() {
        return this.methodToInvoke;
    }

    public void setMethodToInvoke(Method m) {
        this.methodToInvoke = m;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String m) {
        this.httpMethod = m;
    }

    public void setAnnotatedMethod(Method m) {
        this.annotatedMethod = m;
        this.checkMediaTypes();
    }

    public Method getAnnotatedMethod() {
        return this.annotatedMethod;
    }

    public boolean isSubResourceLocator() {
        return this.httpMethod == null;
    }

    public List<MediaType> getProduceTypes() {
        return this.produceMimes;
    }

    public List<MediaType> getConsumeTypes() {
        return this.consumeMimes;
    }

    private void checkMediaTypes() {
        ConsumeMime cm = (ConsumeMime)AnnotationUtils.getMethodAnnotation(this.annotatedMethod, ConsumeMime.class);
        if (cm != null) {
            this.consumeMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(cm.value()));
        } else if (this.classResourceInfo != null) {
            this.consumeMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getConsumeTypes(this.classResourceInfo.getConsumeMime()));
        }
        ProduceMime pm = (ProduceMime)AnnotationUtils.getMethodAnnotation(this.annotatedMethod, ProduceMime.class);
        if (pm != null) {
            this.produceMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getMediaTypes(pm.value()));
        } else if (this.classResourceInfo != null) {
            this.produceMimes = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(this.classResourceInfo.getProduceMime()));
        }
    }
}

