/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    private static final String CHARSET_PARAMETER = "charset";
    private static Map<String, JAXBContext> packageContexts = new WeakHashMap<String, JAXBContext>();
    private static Map<Class<?>, JAXBContext> classContexts = new WeakHashMap();
    @Context
    protected ContextResolver<JAXBContext> resolver;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns) {
        return this.isSupported(type, genericType, anns) || AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class) != null;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return this.isSupported(type, genericType, annotations);
    }

    public long getSize(Object o) {
        return -1L;
    }

    protected JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext context;
        if (this.resolver != null && (context = (JAXBContext)this.resolver.getContext(type)) != null) {
            return context;
        }
        context = this.getPackageContext(type);
        if (context == null && type != genericType) {
            context = this.getPackageContext(InjectionUtils.getActualType(genericType));
        }
        return context != null ? context : this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getClassContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = classContexts;
        synchronized (map) {
            JAXBContext context = classContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                classContexts.put(type, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getPackageContext(Class<?> type) {
        if (type == null) {
            return null;
        }
        Map<String, JAXBContext> map = packageContexts;
        synchronized (map) {
            String packageName = PackageUtils.getPackageName(type);
            JAXBContext context = packageContexts.get(packageName);
            if (context == null) {
                try {
                    context = JAXBContext.newInstance((String)packageName, (ClassLoader)type.getClassLoader());
                    packageContexts.put(packageName, context);
                    return context;
                }
                catch (JAXBException ex) {
                    LOG.warning("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
                    return null;
                }
            }
        }
        return null;
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations) {
        return type.getAnnotation(XmlRootElement.class) != null || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryForClass(type) || type != genericType && this.objectFactoryForType(genericType);
    }

    private boolean objectFactoryForClass(Class<?> type) {
        try {
            return type.getClassLoader().loadClass(PackageUtils.getPackageName(type) + ".ObjectFactory") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryForClass(InjectionUtils.getActualType(genericType));
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, MediaType m) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        String enc = (String)m.getParameters().get(CHARSET_PARAMETER);
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        return marshaller;
    }

    protected Class<?> getActualType(Class<?> type, Type genericType) {
        Class<?> theType = null;
        theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        return theType;
    }

    protected Object checkAdapter(Object obj, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter != null) {
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().newInstance();
                return xmlAdapter.marshal(obj);
            }
            catch (Exception ex) {
                LOG.warning("Problem using the XmlJavaTypeAdapter");
                ex.printStackTrace();
            }
        }
        return obj;
    }
}

