/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;

public final class BindingAnnotator
implements Annotator {
    public void annotate(JavaAnnotatable ja) {
        if (!(ja instanceof JavaInterface)) {
            throw new RuntimeException("BindingAnnotator can only annotate JavaInterface");
        }
        JavaInterface intf = (JavaInterface)ja;
        if (this.processBinding(intf)) {
            JAnnotation bindingAnnotation = new JAnnotation(SOAPBinding.class);
            if (!SOAPBinding.Style.DOCUMENT.equals((Object)intf.getSOAPStyle())) {
                bindingAnnotation.addElement(new JAnnotationElement("style", intf.getSOAPStyle()));
            }
            if (!SOAPBinding.Use.LITERAL.equals((Object)intf.getSOAPUse())) {
                bindingAnnotation.addElement(new JAnnotationElement("use", intf.getSOAPUse()));
            }
            if (intf.getSOAPStyle() == SOAPBinding.Style.DOCUMENT) {
                bindingAnnotation.addElement(new JAnnotationElement("parameterStyle", intf.getSOAPParameterStyle()));
            }
            intf.addAnnotation(bindingAnnotation);
        }
    }

    private boolean processBinding(JavaInterface intf) {
        SOAPBinding.Style soapStyle = intf.getSOAPStyle();
        SOAPBinding.Use soapUse = intf.getSOAPUse();
        boolean isWrapped = true;
        int count = 0;
        for (JavaMethod method : intf.getMethods()) {
            if (!method.isWrapperStyle()) {
                isWrapped = false;
                ++count;
            }
            if (soapStyle == null && method.getSoapStyle() != null) {
                soapStyle = method.getSoapStyle();
            }
            if (soapUse != null || method.getSoapUse() == null) continue;
            soapUse = method.getSoapUse();
        }
        if (soapStyle == SOAPBinding.Style.DOCUMENT) {
            intf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
            if (isWrapped) {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
            } else {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.BARE);
            }
        } else if (soapStyle == null) {
            intf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
            if (isWrapped) {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
            } else {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.BARE);
            }
        } else {
            intf.setSOAPStyle(SOAPBinding.Style.RPC);
        }
        if (soapUse == SOAPBinding.Use.LITERAL) {
            intf.setSOAPUse(SOAPBinding.Use.LITERAL);
        } else if (soapUse == null) {
            intf.setSOAPUse(SOAPBinding.Use.LITERAL);
        } else {
            intf.setSOAPUse(SOAPBinding.Use.ENCODED);
        }
        if (intf.getSOAPStyle() == SOAPBinding.Style.DOCUMENT && count != 0 && count != intf.getMethods().size()) {
            return false;
        }
        return intf.getSOAPStyle() != SOAPBinding.Style.DOCUMENT || intf.getSOAPUse() != SOAPBinding.Use.LITERAL || intf.getSOAPParameterStyle() != SOAPBinding.ParameterStyle.WRAPPED;
    }
}

