/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContexts;
import org.ops4j.pax.web.extender.whiteboard.internal.Registration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTracker<T, R extends Registration>
extends ServiceTracker
implements HttpServiceListener {
    private static final Log LOGGER = LogFactory.getLog(AbstractTracker.class);
    private HttpService m_httpService;
    final Lock lock = new ReentrantLock();
    private final Map<T, R> m_tracked = Collections.synchronizedMap(new IdentityHashMap());
    private final RegisteredContexts m_registeredContexts;

    AbstractTracker(RegisteredContexts registeredContexts, BundleContext bundleContext, Class<T> clazz) {
        super(AbstractTracker.validateBundleContext(bundleContext), clazz.getName(), null);
        if (registeredContexts == null) {
            throw new IllegalArgumentException("Registered contexts cannot be null");
        }
        this.m_registeredContexts = registeredContexts;
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Bundle context cannot be null");
        }
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference serviceReference) {
        LOGGER.debug("Service available [" + serviceReference + "]");
        Object registered = super.addingService(serviceReference);
        if (registered != null) {
            HttpService httpService = null;
            this.lock.lock();
            try {
                httpService = this.m_httpService;
            }
            finally {
                this.lock.unlock();
            }
            R registration = this.createRegistration(serviceReference, registered);
            if (httpService != null) {
                if (this.localRegister(httpService, registered, registration)) {
                    this.m_tracked.put(registered, registration);
                }
            } else {
                this.m_tracked.put(registered, registration);
                LOGGER.info("Keeping track of registered [" + registered + "] -> [" + registration + "] for later registration");
            }
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference serviceReference, Object unpublished) {
        Registration registration;
        LOGGER.debug("Service removed [" + serviceReference + "]");
        super.removedService(serviceReference, unpublished);
        HttpService httpService = null;
        this.lock.lock();
        try {
            httpService = this.m_httpService;
        }
        finally {
            this.lock.unlock();
        }
        if (httpService != null && (registration = (Registration)this.m_tracked.get(unpublished)) != null) {
            this.m_tracked.remove(unpublished);
            this.unregister(httpService, unpublished, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void available(HttpService httpService) {
        if (httpService == null) {
            throw new IllegalArgumentException("Http service cannot be null");
        }
        this.lock.lock();
        try {
            if (this.m_httpService != null) {
                return;
            }
            this.m_httpService = httpService;
        }
        finally {
            this.lock.unlock();
        }
        Map<T, R> map = this.m_tracked;
        synchronized (map) {
            for (Map.Entry<T, R> entry : this.m_tracked.entrySet()) {
                this.localRegister(httpService, entry.getKey(), (Registration)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unavailable(HttpService httpService) {
        if (httpService == null) {
            throw new IllegalArgumentException("Http service cannot be null");
        }
        HttpService service = null;
        this.lock.lock();
        try {
            if (this.m_httpService == null || this.m_httpService != httpService) {
                return;
            }
            service = this.m_httpService;
            this.m_httpService = null;
        }
        finally {
            this.lock.unlock();
        }
        Map<T, R> map = this.m_tracked;
        synchronized (map) {
            for (Map.Entry<T, R> entry : this.m_tracked.entrySet()) {
                this.unregister(service, entry.getKey(), (Registration)entry.getValue());
            }
        }
    }

    private boolean localRegister(HttpService httpService, T published, R registration) {
        try {
            boolean registered = this.register(httpService, published, registration);
            LOGGER.info("Registered [" + published + "] -> [" + registration + "]");
            return registered;
        }
        catch (Exception e) {
            LOGGER.error("Could not register [" + published + "]", e);
            LOGGER.info("Keeping track of [" + published + "] -> [" + registration + "] for later registration");
            return false;
        }
    }

    RegisteredContexts getRegisteredContexts() {
        return this.m_registeredContexts;
    }

    abstract boolean register(HttpService var1, T var2, R var3) throws Exception;

    abstract void unregister(HttpService var1, T var2, R var3);

    abstract R createRegistration(ServiceReference var1, T var2);
}

