/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.FiltersTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpContextsTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.ListenersTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContexts;
import org.ops4j.pax.web.extender.whiteboard.internal.ResourcesTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.ServletsTracker;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Log LOG = LogFactory.getLog(Activator.class);
    private HttpContextsTracker m_httpContextsTracker;
    private ServletsTracker m_servletsTracker;
    private ResourcesTracker m_resourcesTracker;
    private FiltersTracker m_filtersTracker;
    private ListenersTracker m_listenersTracker;
    private ServiceTracker m_httpServiceTracker;
    private RegisteredContexts m_registeredContexts;

    public void start(BundleContext bundleContext) throws Exception {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Bundle context cannot be null");
        }
        this.m_registeredContexts = new RegisteredContexts();
        this.trackHttpContexts(bundleContext);
        this.trackServlets(bundleContext);
        this.trackResources(bundleContext);
        if (Activator.webContainerAvailable()) {
            this.trackFilters(bundleContext);
            this.trackListeners(bundleContext);
        } else {
            LOG.info("Filters tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.info("Event Listeners tracking has been disabled as the WebContainer (Pax Web) is not available");
        }
        this.trackHttpServices(bundleContext);
        LOG.debug("Pax Web Extender started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Bundle context cannot be null");
        }
        if (this.m_httpContextsTracker != null) {
            this.m_httpContextsTracker.close();
            this.m_httpContextsTracker = null;
        }
        if (this.m_servletsTracker != null) {
            this.m_servletsTracker.close();
            this.m_servletsTracker = null;
        }
        if (this.m_resourcesTracker != null) {
            this.m_resourcesTracker.close();
            this.m_resourcesTracker = null;
        }
        if (this.m_filtersTracker != null) {
            this.m_filtersTracker.close();
            this.m_filtersTracker = null;
        }
        if (this.m_listenersTracker != null) {
            this.m_listenersTracker.close();
            this.m_listenersTracker = null;
        }
        if (this.m_httpServiceTracker != null) {
            this.m_httpServiceTracker.close();
            this.m_httpServiceTracker = null;
        }
        this.m_registeredContexts = null;
        LOG.debug("Pax Web Extender stopped");
    }

    private void trackHttpContexts(BundleContext bundleContext) {
        this.m_httpContextsTracker = new HttpContextsTracker(this.m_registeredContexts, bundleContext);
        this.m_httpContextsTracker.open();
    }

    private void trackServlets(BundleContext bundleContext) {
        this.m_servletsTracker = new ServletsTracker(this.m_registeredContexts, bundleContext);
        this.m_servletsTracker.open();
    }

    private void trackResources(BundleContext bundleContext) {
        this.m_resourcesTracker = new ResourcesTracker(this.m_registeredContexts, bundleContext);
        this.m_resourcesTracker.open();
    }

    private void trackFilters(BundleContext bundleContext) {
        this.m_filtersTracker = new FiltersTracker(this.m_registeredContexts, bundleContext);
        this.m_filtersTracker.open();
    }

    private void trackListeners(BundleContext bundleContext) {
        this.m_listenersTracker = new ListenersTracker(this.m_registeredContexts, bundleContext);
        this.m_listenersTracker.open();
    }

    private void trackHttpServices(BundleContext bundleContext) {
        ArrayList<HttpServiceListener> validListeners = new ArrayList<HttpServiceListener>();
        validListeners.add(this.m_registeredContexts);
        validListeners.add(this.m_httpContextsTracker);
        validListeners.add(this.m_servletsTracker);
        validListeners.add(this.m_resourcesTracker);
        if (this.m_filtersTracker != null) {
            validListeners.add(this.m_filtersTracker);
        }
        if (this.m_listenersTracker != null) {
            validListeners.add(this.m_listenersTracker);
        }
        this.m_httpServiceTracker = new HttpServiceTracker(bundleContext, validListeners.toArray(new HttpServiceListener[validListeners.size()]));
        this.m_httpServiceTracker.open();
    }

    private static boolean webContainerAvailable() {
        try {
            return WebContainer.class != null;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }
}

