/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.FilterRegistration;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContexts;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersTracker
extends AbstractTracker<Filter, FilterRegistration> {
    private static final Log LOG = LogFactory.getLog(FiltersTracker.class);

    public FiltersTracker(RegisteredContexts registeredContexts, BundleContext bundleContext) {
        super(registeredContexts, bundleContext, Filter.class);
    }

    @Override
    boolean register(HttpService httpService, Filter published, FilterRegistration registration) throws Exception {
        if (!(httpService instanceof WebContainer)) {
            LOG.error("Internal error: In use HttpService is not an WebContainer (from Pax Web). Please Report");
            return false;
        }
        HttpContext httpContext = this.getRegisteredContexts().getHttpContext(registration.getHttpContextId(), registration.getBundle());
        if (httpContext == null) {
            throw new Exception("HttpContext with id [" + registration.getHttpContextId() + "] could not be found");
        }
        ((WebContainer)httpService).registerFilter(published, registration.getUrlPatterns(), registration.getServletAliases(), null, httpContext);
        return true;
    }

    @Override
    void unregister(HttpService httpService, Filter unpublished, FilterRegistration registration) {
        if (!(httpService instanceof WebContainer)) {
            LOG.error("Internal error: In use HttpService is not an WebContainer (from Pax Web). Please Report");
            return;
        }
        ((WebContainer)httpService).unregisterFilter(unpublished);
    }

    @Override
    FilterRegistration createRegistration(ServiceReference serviceReference, Filter published) {
        Object httpContextId = serviceReference.getProperty("httpContext");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid http context id");
            return null;
        }
        Object urlPatternsProp = serviceReference.getProperty("urlPatterns");
        String[] urlPatterns = null;
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = (String[])urlPatternsProp;
            } else {
                LOG.warn("Registered filter [" + published + "] has an invalid url pattern property (must be String or String[])");
                return null;
            }
        }
        Object servletAliasesProp = serviceReference.getProperty("servletAliases");
        String[] servletAliases = null;
        if (servletAliasesProp != null) {
            if (servletAliasesProp instanceof String) {
                servletAliases = new String[]{(String)servletAliasesProp};
            } else if (servletAliasesProp instanceof String[]) {
                servletAliases = (String[])servletAliasesProp;
            } else {
                LOG.warn("Registered filter [" + published + "] has an invalid servlet aliases property (must be String or String[])");
                return null;
            }
        }
        return new FilterRegistration(serviceReference.getBundle(), (String)httpContextId, urlPatterns, servletAliases);
    }
}

