/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

class HttpContextProxy
implements HttpContext {
    private static final Log LOG = LogFactory.getLog(HttpContextProxy.class);
    private final Bundle m_bundle;
    private final HttpContext m_httpContext;

    HttpContextProxy(HttpContext httpContext, Bundle bundle) {
        if (httpContext == null) {
            throw new IllegalArgumentException("Http Context cannot be null");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null");
        }
        this.m_httpContext = httpContext;
        this.m_bundle = bundle;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.m_httpContext.handleSecurity(request, response);
    }

    public URL getResource(String name) {
        LOG.debug("Searching bundle [" + this.m_bundle + "] for resource [" + name + "]");
        URL url = this.m_bundle.getResource(name);
        if (url != null) {
            LOG.debug("Resource found as url [" + url + "]");
        } else {
            LOG.debug("Resource not found");
        }
        return url;
    }

    public String getMimeType(String name) {
        return this.m_httpContext.getMimeType(name);
    }
}

