/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContexts;
import org.ops4j.pax.web.extender.whiteboard.internal.Registration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpContextsTracker
extends AbstractTracker<HttpContext, Registration> {
    private static final Log LOG = LogFactory.getLog(HttpContextsTracker.class);

    public HttpContextsTracker(RegisteredContexts registeredContexts, BundleContext bundleContext) {
        super(registeredContexts, bundleContext, HttpContext.class);
    }

    @Override
    boolean register(HttpService httpService, HttpContext published, Registration registration) throws Exception {
        this.getRegisteredContexts().registerHttpContext(registration.getHttpContextId(), registration.getBundle(), published);
        return true;
    }

    @Override
    void unregister(HttpService httpService, HttpContext unpublished, Registration registration) {
        this.getRegisteredContexts().unregisterHttpContext(registration.getHttpContextId(), registration.getBundle());
    }

    @Override
    Registration createRegistration(ServiceReference serviceReference, HttpContext published) {
        Object httpContextId = serviceReference.getProperty("httpContext");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered http context [" + published + "] did not contain a valid http context id");
            return null;
        }
        return new Registration(serviceReference.getBundle(), (String)httpContextId);
    }
}

