/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    private static final Log LOGGER = LogFactory.getLog(HttpServiceTracker.class);
    private HttpServiceListener[] m_listeners;
    private HttpService m_httpService;
    Lock lock;

    public HttpServiceTracker(BundleContext bundleContext, HttpServiceListener[] listeners) {
        super(HttpServiceTracker.validateBundleContext(bundleContext), HttpService.class.getName(), null);
        if (listeners == null) {
            throw new IllegalArgumentException("Http Service listeners cannot be null");
        }
        this.m_listeners = listeners;
        this.lock = new ReentrantLock();
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Bundle context cannot be null");
        }
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference serviceReference) {
        LOGGER.debug("HttpService available [" + serviceReference + "]");
        this.lock.lock();
        HttpService httpService = null;
        try {
            if (this.m_httpService != null) {
                Object object = super.addingService(serviceReference);
                return object;
            }
            httpService = this.m_httpService = (HttpService)super.addingService(serviceReference);
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.m_listeners) {
            listener.available(httpService);
        }
        return httpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference serviceReference, Object service) {
        LOGGER.debug("HttpService removed [" + serviceReference + "]");
        this.lock.lock();
        HttpService httpService = null;
        try {
            super.removedService(serviceReference, service);
            if (this.m_httpService != service) {
                return;
            }
            httpService = this.m_httpService;
            this.m_httpService = null;
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.m_listeners) {
            listener.unavailable(httpService);
        }
        this.lock.lock();
        try {
            this.m_httpService = (HttpService)this.getService();
            if (this.m_httpService == null) {
                return;
            }
            httpService = this.m_httpService;
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.m_listeners) {
            listener.available(httpService);
        }
    }
}

