/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.internal.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContexts;
import org.ops4j.pax.web.extender.whiteboard.internal.Registration;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenersTracker
extends AbstractTracker<EventListener, Registration> {
    private static final Log LOG = LogFactory.getLog(ListenersTracker.class);

    public ListenersTracker(RegisteredContexts registeredContexts, BundleContext bundleContext) {
        super(registeredContexts, bundleContext, EventListener.class);
    }

    @Override
    boolean register(HttpService httpService, EventListener published, Registration registration) throws Exception {
        if (!(httpService instanceof WebContainer)) {
            LOG.error("Internal error: In use HttpService is not an WebContainer (from Pax Web). Please Report");
            return false;
        }
        HttpContext httpContext = this.getRegisteredContexts().getHttpContext(registration.getHttpContextId(), registration.getBundle());
        if (httpContext == null) {
            throw new Exception("HttpContext with id [" + registration.getHttpContextId() + "] could not be found");
        }
        ((WebContainer)httpService).registerEventListener(published, httpContext);
        return true;
    }

    @Override
    void unregister(HttpService httpService, EventListener unpublished, Registration registration) {
        if (!(httpService instanceof WebContainer)) {
            LOG.error("Internal error: In use HttpService is not an WebContainer (from Pax Web). Please Report");
            return;
        }
        ((WebContainer)httpService).unregisterEventListener(unpublished);
    }

    @Override
    Registration createRegistration(ServiceReference serviceReference, EventListener published) {
        Object httpContextId = serviceReference.getProperty("httpContext");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid http context id");
            return null;
        }
        return new Registration(serviceReference.getBundle(), (String)httpContextId);
    }
}

