/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpContextProxy;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContextKey;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

class RegisteredContexts
implements HttpServiceListener {
    private final Map<RegisteredContextKey, HttpContext> m_httpContextIdMapping = Collections.synchronizedMap(new HashMap());
    private HttpService m_httpService;

    RegisteredContexts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpContext getHttpContext(String httpContextId, Bundle bundle) {
        HttpContext httpContext;
        RegisteredContextKey key = new RegisteredContextKey(bundle, httpContextId);
        Map<RegisteredContextKey, HttpContext> map = this.m_httpContextIdMapping;
        synchronized (map) {
            httpContext = this.m_httpContextIdMapping.get(key);
            if (httpContext == null && "default".equals(httpContextId) && this.m_httpService != null) {
                httpContext = new HttpContextProxy(this.m_httpService.createDefaultHttpContext(), bundle);
                this.m_httpContextIdMapping.put(key, httpContext);
            }
        }
        return httpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpContext(String httpContextId, Bundle bundle, HttpContext httpContext) throws Exception {
        RegisteredContextKey key = new RegisteredContextKey(bundle, httpContextId);
        Map<RegisteredContextKey, HttpContext> map = this.m_httpContextIdMapping;
        synchronized (map) {
            if (this.m_httpContextIdMapping.containsKey(key)) {
                throw new Exception("HttpContext with id [" + httpContextId + "] is already registered");
            }
            this.m_httpContextIdMapping.put(key, httpContext);
        }
    }

    public void unregisterHttpContext(String httpContextId, Bundle bundle) {
        this.m_httpContextIdMapping.remove(new RegisteredContextKey(bundle, httpContextId));
    }

    public void available(HttpService httpService) {
        this.m_httpService = httpService;
    }

    public void unavailable(HttpService httpService) {
        if (this.m_httpService != null && this.m_httpService.equals(httpService)) {
            this.m_httpService = null;
        }
    }
}

