/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.extender.whiteboard.Resources;
import org.ops4j.pax.web.extender.whiteboard.internal.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.AliasBasedRegistration;
import org.ops4j.pax.web.extender.whiteboard.internal.RegisteredContexts;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesTracker
extends AbstractTracker<Resources, AliasBasedRegistration> {
    private static final Log LOG = LogFactory.getLog(ResourcesTracker.class);

    public ResourcesTracker(RegisteredContexts registeredContexts, BundleContext bundleContext) {
        super(registeredContexts, bundleContext, Resources.class);
    }

    @Override
    boolean register(HttpService httpService, Resources published, AliasBasedRegistration registration) throws Exception {
        HttpContext httpContext = this.getRegisteredContexts().getHttpContext(registration.getHttpContextId(), registration.getBundle());
        if (httpContext == null) {
            throw new Exception("HttpContext with id [" + registration.getHttpContextId() + "] could not be found");
        }
        httpService.registerResources(registration.getAlias(), published.getResources(), httpContext);
        return true;
    }

    @Override
    void unregister(HttpService httpService, Resources unpublished, AliasBasedRegistration registration) {
        httpService.unregister(registration.getAlias());
    }

    @Override
    AliasBasedRegistration createRegistration(ServiceReference serviceReference, Resources published) {
        Object alias = serviceReference.getProperty("alias");
        if (alias == null || !(alias instanceof String) || ((String)alias).trim().length() == 0) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid alias property");
            return null;
        }
        Object httpContextId = serviceReference.getProperty("httpContext");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid http context id");
            return null;
        }
        return new AliasBasedRegistration(serviceReference.getBundle(), (String)httpContextId, (String)alias);
    }
}

