/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.extender.OsgiServiceDependencyFactory;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextExecutorStateAccessor;
import org.springframework.osgi.extender.internal.dependencies.startup.ContextState;
import org.springframework.osgi.extender.internal.dependencies.startup.MandatoryServiceDependency;
import org.springframework.osgi.service.importer.OsgiServiceDependency;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitEndedEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;
import org.springframework.osgi.util.OsgiListenerUtils;
import org.springframework.osgi.util.OsgiStringUtils;

public class DependencyServiceManager {
    private static final Log log = LogFactory.getLog((Class)DependencyServiceManager.class);
    protected final Map dependencies = Collections.synchronizedMap(new LinkedHashMap());
    protected final Map unsatisfiedDependencies = Collections.synchronizedMap(new LinkedHashMap());
    private final ContextExecutorStateAccessor contextStateAccessor;
    private final BundleContext bundleContext;
    private final ServiceListener listener;
    private final DelegatedExecutionOsgiBundleApplicationContext context;
    private final Runnable executeIfDone;
    private final long waitTime;
    private List dependencyFactories;

    public DependencyServiceManager(ContextExecutorStateAccessor executor, DelegatedExecutionOsgiBundleApplicationContext context, List dependencyFactories, Runnable executeIfDone, long maxWaitTime) {
        this.contextStateAccessor = executor;
        this.context = context;
        this.dependencyFactories = new ArrayList(8);
        if (dependencyFactories != null) {
            this.dependencyFactories.addAll(dependencyFactories);
        }
        this.waitTime = maxWaitTime;
        this.bundleContext = context.getBundleContext();
        this.listener = new DependencyServiceListener();
        this.executeIfDone = executeIfDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findServiceDependencies() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldTCCL = currentThread.getContextClassLoader();
        boolean debug = log.isDebugEnabled();
        boolean trace = log.isTraceEnabled();
        try {
            currentThread.setContextClassLoader(this.context.getClassLoader());
            ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
            if (trace) {
                log.trace((Object)("Looking for dependency factories inside bean factory [" + beanFactory.toString() + "]"));
            }
            Map localFactories = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)OsgiServiceDependencyFactory.class, (boolean)true, (boolean)false);
            if (debug) {
                log.debug((Object)("Discovered local dependency factories: " + localFactories.keySet()));
            }
            this.dependencyFactories.addAll(localFactories.values());
            Iterator iterator = this.dependencyFactories.iterator();
            while (iterator.hasNext()) {
                OsgiServiceDependencyFactory dependencyFactory = (OsgiServiceDependencyFactory)iterator.next();
                Collection discoveredDependencies = null;
                try {
                    discoveredDependencies = dependencyFactory.getServiceDependencies(this.bundleContext, beanFactory);
                }
                catch (Exception ex) {
                    log.warn((Object)("Dependency factory " + dependencyFactory + " threw exception while detecting dependencies for beanFactory " + beanFactory + " in " + this.context.getDisplayName()), (Throwable)ex);
                    throw ex;
                }
                if (discoveredDependencies == null) continue;
                Iterator dependencyIterator = discoveredDependencies.iterator();
                while (dependencyIterator.hasNext()) {
                    OsgiServiceDependency dependency = (OsgiServiceDependency)dependencyIterator.next();
                    MandatoryServiceDependency msd = new MandatoryServiceDependency(this.bundleContext, dependency);
                    this.dependencies.put(msd, dependency.getBeanName());
                    if (msd.isServicePresent()) continue;
                    log.info((Object)("Adding OSGi service dependency for importer [" + msd.getBeanName() + "] matching OSGi filter [" + msd.filterAsString + "]"));
                    this.unsatisfiedDependencies.put(msd, dependency.getBeanName());
                }
            }
        }
        finally {
            currentThread.setContextClassLoader(oldTCCL);
        }
        if (debug) {
            log.debug((Object)(this.dependencies.size() + " OSGi service dependencies, " + this.unsatisfiedDependencies.size() + " unsatisfied (for beans " + this.unsatisfiedDependencies.values() + ") in " + this.context.getDisplayName()));
        }
        if (!this.unsatisfiedDependencies.isEmpty()) {
            log.info((Object)(this.context.getDisplayName() + " is waiting for unsatisfied dependencies [" + this.unsatisfiedDependencies.values() + "]"));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Total OSGi service dependencies beans " + this.dependencies.values()));
            log.trace((Object)("Unsatified OSGi service dependencies beans " + this.unsatisfiedDependencies.values()));
        }
    }

    protected boolean isSatisfied() {
        return this.unsatisfiedDependencies.isEmpty();
    }

    public Map getUnsatisfiedDependencies() {
        return this.unsatisfiedDependencies;
    }

    protected void register() {
        String filter = this.createDependencyFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.context.getDisplayName() + " has registered service dependency dependencyDetector with filter: " + filter));
        }
        this.sendInitialDependencyEvents();
        OsgiListenerUtils.addServiceListener((BundleContext)this.bundleContext, (ServiceListener)this.listener, (String)filter);
    }

    protected String createDependencyFilter() {
        boolean multiple = this.unsatisfiedDependencies.size() > 1;
        StringBuffer sb = new StringBuffer(100 * this.unsatisfiedDependencies.size());
        if (multiple) {
            sb.append("(|");
        }
        Iterator i = this.unsatisfiedDependencies.keySet().iterator();
        while (i.hasNext()) {
            sb.append(((MandatoryServiceDependency)i.next()).filterAsString);
        }
        if (multiple) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected void deregister() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deregistering service dependency dependencyDetector for " + this.context.getDisplayName()));
        }
        OsgiListenerUtils.removeServiceListener((BundleContext)this.bundleContext, (ServiceListener)this.listener);
    }

    private void sendInitialDependencyEvents() {
        Iterator iterator = this.unsatisfiedDependencies.keySet().iterator();
        while (iterator.hasNext()) {
            MandatoryServiceDependency entry = (MandatoryServiceDependency)iterator.next();
            OsgiServiceDependencyWaitStartingEvent nestedEvent = new OsgiServiceDependencyWaitStartingEvent((Object)this.context, entry.getServiceDependency(), this.waitTime);
            BootstrappingDependencyEvent dependencyEvent = new BootstrappingDependencyEvent((ApplicationContext)this.context, this.context.getBundle(), (OsgiServiceDependencyEvent)nestedEvent);
            this.publishEvent(dependencyEvent);
        }
    }

    private void sendDependencyUnsatisfiedEvent(MandatoryServiceDependency dependency) {
        OsgiServiceDependencyWaitStartingEvent nestedEvent = new OsgiServiceDependencyWaitStartingEvent((Object)this.context, dependency.getServiceDependency(), this.waitTime);
        BootstrappingDependencyEvent dependencyEvent = new BootstrappingDependencyEvent((ApplicationContext)this.context, this.context.getBundle(), (OsgiServiceDependencyEvent)nestedEvent);
        this.publishEvent(dependencyEvent);
    }

    private void sendDependencySatisfiedEvent(MandatoryServiceDependency dependency) {
        OsgiServiceDependencyWaitEndedEvent nestedEvent = new OsgiServiceDependencyWaitEndedEvent((Object)this.context, dependency.getServiceDependency(), this.waitTime);
        BootstrappingDependencyEvent dependencyEvent = new BootstrappingDependencyEvent((ApplicationContext)this.context, this.context.getBundle(), (OsgiServiceDependencyEvent)nestedEvent);
        this.publishEvent(dependencyEvent);
    }

    private void publishEvent(BootstrappingDependencyEvent dependencyEvent) {
        this.contextStateAccessor.getEventMulticaster().multicastEvent((OsgiBundleApplicationContextEvent)dependencyEvent);
    }

    private class DependencyServiceListener
    implements ServiceListener {
        private DependencyServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            boolean trace = log.isTraceEnabled();
            try {
                if (DependencyServiceManager.this.unsatisfiedDependencies.isEmpty()) {
                    if (trace) {
                        log.trace((Object)("Handling service event, but no unsatisfied dependencies exist for " + DependencyServiceManager.this.context.getDisplayName()));
                    }
                    return;
                }
                ServiceReference ref = serviceEvent.getServiceReference();
                if (trace) {
                    log.trace((Object)("Handling service event [" + OsgiStringUtils.nullSafeToString((ServiceEvent)serviceEvent) + ":" + OsgiStringUtils.nullSafeToString((ServiceReference)ref) + "] for " + DependencyServiceManager.this.context.getDisplayName()));
                }
                this.updateDependencies(serviceEvent);
                ContextState state = DependencyServiceManager.this.contextStateAccessor.getContextState();
                if (state.isResolved()) {
                    DependencyServiceManager.this.deregister();
                    return;
                }
                if (DependencyServiceManager.this.unsatisfiedDependencies.isEmpty()) {
                    DependencyServiceManager.this.deregister();
                    log.info((Object)("No unsatisfied OSGi service dependencies; completing initialization for " + DependencyServiceManager.this.context.getDisplayName()));
                    DependencyServiceManager.this.executeIfDone.run();
                }
            }
            catch (Throwable e) {
                log.error((Object)("Exception during dependency processing for " + DependencyServiceManager.this.context.getDisplayName()), e);
            }
        }

        private void updateDependencies(ServiceEvent serviceEvent) {
            boolean trace = log.isTraceEnabled();
            boolean debug = log.isDebugEnabled();
            Iterator i = DependencyServiceManager.this.dependencies.keySet().iterator();
            block4: while (i.hasNext()) {
                MandatoryServiceDependency dependency = (MandatoryServiceDependency)i.next();
                if (dependency.matches(serviceEvent)) {
                    switch (serviceEvent.getType()) {
                        case 1: 
                        case 2: {
                            DependencyServiceManager.this.unsatisfiedDependencies.remove(dependency);
                            if (debug) {
                                log.debug((Object)("Found service for " + DependencyServiceManager.this.context.getDisplayName() + "; eliminating " + dependency + ", remaining [" + DependencyServiceManager.this.unsatisfiedDependencies + "]"));
                            }
                            DependencyServiceManager.this.sendDependencySatisfiedEvent(dependency);
                            continue block4;
                        }
                        case 4: {
                            DependencyServiceManager.this.unsatisfiedDependencies.put(dependency, dependency.getBeanName());
                            if (debug) {
                                log.debug((Object)("Service unregistered; adding " + dependency));
                            }
                            DependencyServiceManager.this.sendDependencyUnsatisfiedEvent(dependency);
                            continue block4;
                        }
                    }
                    if (!debug) continue;
                    log.debug((Object)("Unknown service event type for: " + dependency));
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)(dependency + " does not match: " + OsgiStringUtils.nullSafeToString((ServiceReference)serviceEvent.getServiceReference())));
            }
        }
    }
}

